// Plik caoimageclient.cs  (kompilowany do pliku wykonywalnego)
using System;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Collections;
using System.Drawing;
using System.IO;
using caoimage;
// Kompilacja: csc   /r:caoimageserver.dll caoimageclient.cs
namespace SimpleImageClient
{
   class ImageClient
   {     
      static void Main(string[] args)
      {          
         // (1) Rejestruje kana dla kombinacji TCP-binarny
         TcpChannel c = new TcpChannel();
         ChannelServices.RegisterChannel(c);
         // (2) Rejestruje typ obiektw aktywowanych przez klienta
         Type ServerType = typeof(ImageServer);
         RemotingConfiguration.RegisterActivatedClientType(
           ServerType,
           "tcp://localhost:3201");  
		 ImageServer imgMgr=null;           
         bool serverOK=true;    // Informuje o tym, e serwer dziaa
         // (3) Tworzy instancj zdalnego obiektu
         try{
             imgMgr = new ImageServer();
         } catch (Exception ex) {        
             Console.WriteLine(ex.Message);
             serverOK=false;
         }
         if (serverOK)
      {
         string oper = "";
         while (oper != "Z")
         {
            Console.WriteLine( 
               "(W)ywietl pliki, (P)obierz, (Z)akocz");
            oper = Console.ReadLine();
            oper = oper.ToUpper();
            if (oper == "P") {
               Console.WriteLine(
                  "Podaj nazw pliku do pobrania: ");
               string fname = Console.ReadLine();
               // Obsuga wyjtku, jeli nie mona odnale pliku
               try
               {
                  // da plik z serwera
                  byte[] image = imgMgr.GetMovieImage(fname);
                  MemoryStream memStream = new
                     MemoryStream(image);
                  Console.WriteLine("Rozmiar rysunku: {0}",
                                     memStream.Length);
                  // Przeksztaca strumie pamici na bitmap
                  Bitmap bm = new Bitmap(memStream);
                  // Zapisuje rysunek w lokalnym systemie
                  bm.Save("c:\\cs\\"+fname,
                     System.Drawing.Imaging.ImageFormat.Jpeg);
               } catch (Exception ex) {
                  Console.WriteLine(ex.Message);
               }
            }
            else    
            {
               if (oper == "W") // Wywietla nazwy plikw
               {
                  try
                  {
                     ArrayList images = imgMgr.GetFiles();
                     for (int i = 0; i < images.Count; i++)
                     {
                        Console.WriteLine(images[i]);
                     }
                  } catch (Exception ex) {
                     Console.WriteLine(ex.Message);
                  }
               }
            }   // while
         }   // serverOK
      }   // Main
   }   // class
}  // namespace

