using System;
using System.Threading;
using System.IO;
// Demonstruje konieczno synchronizacji wykorzystania zasobw.
// Naley uruchomi kilka razy z poziomu okna konsoli, aby zobaczy problemy z synchronizacj.
public class MyApp
{
    public static void Main()
    {
        CallerClass cc = new CallerClass();
        Thread worker1 = new Thread(new ThreadStart(cc.CallUpdate));
        Thread worker2 = new Thread(new ThreadStart(cc.CallUpdate));
        worker1.Start();
        worker2.Start();
        // Pauza, aby moliwe byo odczytanie informacji
        Thread.Sleep(800);
    }
}
public class CallerClass
{
    WorkClass wc;
    public CallerClass()
    {
        wc = new WorkClass();  // Tworzy obiekt aktualizujcy dziennik
    }
    public void CallUpdate()
    {
        wc.UpdateLog();
    }
}
public class WorkClass
{
    public void UpdateLog()
    {
        // Otwiera strumie do odczytu i zapisu        
        try
        {
            FileStream fs = new FileStream(@"log.txt", FileMode.OpenOrCreate,
               FileAccess.ReadWrite, FileShare.ReadWrite);
            StreamReader sr = new StreamReader(fs);
            // Odczytuje aktualny stan licznika
            string ctr = sr.ReadLine();
            if (ctr == null) ctr = "0";
            int oldCt = int.Parse(ctr) + 1;
            // Jeli w tym miejscu zakoczy si porcja czasu wtku,
            // licznik nie zostanie zaktualizowany
            fs.Seek(0, SeekOrigin.Begin);
            StreamWriter sw = new StreamWriter(fs);
            sw.WriteLine(oldCt.ToString());
            Console.WriteLine(oldCt);
            sw.Close();
            sr.Close();
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.Message);
        }
    }
}	  // WorkClass
