using System;
using System.Threading;
class Stick
{
    bool[] chopStick = { true, true, true, true, true }; // Dostpne widelce
    // Prbuje podnie oba widelce
    public void GetSticks(int left, int right)
    {
        lock (this)
        {
            // Zwalnia blokad i oczekuje na dostp do obu widelcy
            while (!chopStick[left] && !chopStick[right]) Monitor.Wait(this);
            chopStick[right] = false; chopStick[left] = false;
        }
    }

    // Odkada widelec
    public void FreeSticks(int left, int right)
    {
        lock (this)
        {
            chopStick[right] = true;
            chopStick[left] = true;
            // Informuje widelce znajdujce si w kolejce o dostpnoci widelcy
            Monitor.PulseAll(this);
        }
    }
}
class Philosopher
{
    int n;             // Numer filozofa
    int eatDelay;
    int thinkDelay;
    int left, right;
    Stick chopSticks;
    public Philosopher(int n, int thinkTime, int eatTime, Stick sticks)
    {
        this.n = n;
        this.eatDelay = eatTime;
        this.thinkDelay = thinkTime;
        this.chopSticks = sticks;
        // left i right to numery widelcy
        // Pity filozof ma po lewej stronie widelec numer 1
        left = (n == 5) ? 1 : n + 1;
        right = n;
        new Thread(new ThreadStart(Run)).Start();
    }

    public void Run()
    {
        while (true)
        {
            try
            {
                // Filozof myli przez losowy okres czasu
                Thread.Sleep(thinkDelay);
                chopSticks.GetSticks(left - 1, right - 1);
                Console.WriteLine("Filozof {0} je przez {1} ms ", n,
                eatDelay);
                Thread.Sleep(eatDelay);
                chopSticks.FreeSticks(left - 1, right - 1);
            }
            catch { return; }
        }
    }
}    // Koniec klasy Philosopher

public class Diners
{
    public static void Main()
    {
        Stick sticks = new Stick();
        // Tworzy wtki filozofw
        // Czas jedzenia jest losowy
        Random r = new Random(DateTime.Now.Millisecond);
        new Philosopher(1, 100, r.Next(500), sticks);
        new Philosopher(2, 200, r.Next(500), sticks);
        new Philosopher(3, 300, r.Next(500), sticks);
        new Philosopher(4, 400, r.Next(500), sticks);
        new Philosopher(5, 500, r.Next(500), sticks);
    }
}