using System;
using System.Text;
using System.Threading;
using System.IO;
// Wymagane przestrzenie nazw. Kompresja dziaa tylko w wersji 2.0
using System.IO.Compression;
using System.Runtime.Remoting.Messaging;
// Asynchroniczna kompresja danych
public class Async
{
    // Zmienne o zasigu klasy
    Byte[] buffer;
    FileStream infile;
    // Kompresja okrelonego pliku za pomoc kompresji GZip
    public void Compress_File(string fileName)
    {
        bool useAsync = true;  // Okrela asynchroniczne operacje wejcia-wyjcia 
        infile = new FileStream(fileName, FileMode.Open,
          FileAccess.Read, FileShare.Read, 2000, useAsync);
        buffer = new byte[infile.Length];
        int ln = buffer.Length;
        // Wczytuje plik do bufora i pozwala na obsug kompresji zwrotnie wywoywanej metodzie
        IAsyncResult ar = infile.BeginRead(buffer, 0, ln,
          new AsyncCallback(Zip_Completed), fileName);
        Thread.Sleep(500);  // Opnienie pozwala zakoczy dziaanie innych wtkw	
    }
    // Zwrotnie wywoywana metoda suca do kompresji danych i zapisywania ich w pliku
    private void Zip_Completed(IAsyncResult asResult)
    {
        // Pobranie nazwy pliku z obiektu stanu
        string filename = (string)asResult.AsyncState;
        infile.EndRead(asResult);   // Opakowanie asynchronicznego odczytu
        infile.Close();
        // Skompresowane dane s zapisywane do strumienia pamici (obiekt MemoryStream)
        MemoryStream ms = new MemoryStream();
        GZipStream zipStream = new GZipStream(ms, CompressionMode.Compress, true);
        // Zapisanie nieprzetworzonych danych w skompresowanej postaci do strumienia pamici
        zipStream.Write(buffer, 0, buffer.Length);
        zipStream.Close();
        // Zapis skompresowanych danych do pliku
        FileStream fs = new FileStream(filename + ".gz",
          FileMode.OpenOrCreate, FileAccess.Write, FileShare.Read);
        byte[] compressedData = ms.ToArray();
        fs.Write(compressedData, 0, compressedData.Length);
        fs.Close();
        Console.WriteLine("Utworzono plik zip: " + filename + ".gz.");
    }
}
public class ConsoleApp
{
    public static void Main()
    {
        Async a = new Async();
        a.Compress_File(@"c:\kublakhan.txt");
        Console.Read();
    }
}