using System;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Data.OleDb;
using System.Collections;
using System.IO;

// Kompilacja: csc /t:winexe databinding.cs

namespace databinding
{
    public class Form1 : Form
    {
        private System.Windows.Forms.ListBox listBox1;
        private System.Windows.Forms.ComboBox comboBox1;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.Button button1;
        private System.Windows.Forms.Button button2;
        private System.Windows.Forms.Button button3;
        private System.Windows.Forms.Button button5;
        private System.Windows.Forms.TextBox textBox1;
        private System.Windows.Forms.PictureBox pictureBox1;
        private System.Windows.Forms.TextBox textBox2;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.CheckBox checkBox1;
        private System.Windows.Forms.Button button4;
        private System.Windows.Forms.GroupBox groupBox2;
        private System.Windows.Forms.Panel panel1;
        private System.Windows.Forms.TextBox textBox3;
        private System.Windows.Forms.Button button7;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label5;
        private System.ComponentModel.IContainer components = null;
        //
        DataSet ds;
        OleDbDataAdapter da;
        ArrayList movieList;
        BindingManagerBase bmb = null;
        public Form1()
        {
            InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        private void InitializeComponent()
        {
            this.listBox1 = new System.Windows.Forms.ListBox();
            this.comboBox1 = new System.Windows.Forms.ComboBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.panel1 = new System.Windows.Forms.Panel();
            this.textBox3 = new System.Windows.Forms.TextBox();
            this.button1 = new System.Windows.Forms.Button();
            this.button2 = new System.Windows.Forms.Button();
            this.button3 = new System.Windows.Forms.Button();
            this.button5 = new System.Windows.Forms.Button();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.textBox2 = new System.Windows.Forms.TextBox();
            this.label4 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.checkBox1 = new System.Windows.Forms.CheckBox();
            this.button4 = new System.Windows.Forms.Button();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.label5 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.button7 = new System.Windows.Forms.Button();
            // 
            // listBox1
            // 
            //this.listBox1.FormattingEnabled = true;
            this.listBox1.Location = new System.Drawing.Point(16, 47);
            this.listBox1.Name = "listBox1";
            this.listBox1.Size = new System.Drawing.Size(100, 121);
            this.listBox1.TabIndex = 1;

            // 
            // comboBox1
            // 
            //this.comboBox1.FormattingEnabled = true;
            this.comboBox1.Location = new System.Drawing.Point(135, 47);
            this.comboBox1.Name = "comboBox1";
            this.comboBox1.Size = new System.Drawing.Size(107, 21);
            this.comboBox1.TabIndex = 3;
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(16, 26);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(79, 14);
            this.label1.TabIndex = 4;
            this.label1.Text = "ListBox: tabela movies";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(135, 26);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(56, 14);
            this.label3.TabIndex = 6;
            this.label3.Text = "ComboBox";
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.panel1);
            this.groupBox1.Controls.Add(this.listBox1);
            this.groupBox1.Controls.Add(this.comboBox1);
            this.groupBox1.Controls.Add(this.label3);
            this.groupBox1.Controls.Add(this.label1);
            this.groupBox1.Location = new System.Drawing.Point(13, 13);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(248, 202);
            this.groupBox1.TabIndex = 8;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Zoone wizanie";
            // 
            // panel1
            // 
            this.panel1.Controls.Add(this.textBox3);
            this.panel1.Location = new System.Drawing.Point(135, 75);
            this.panel1.Name = "panel1";
            this.panel1.Size = new System.Drawing.Size(98, 99);
            this.panel1.TabIndex = 7;
            // 
            // textBox3
            // 
            this.textBox3.AutoSize = false;
            this.textBox3.Location = new System.Drawing.Point(4, 13);
            this.textBox3.Multiline = true;
            this.textBox3.Name = "textBox3";
            this.textBox3.Size = new System.Drawing.Size(130, 20);
            this.textBox3.TabIndex = 0;
            this.textBox3.Visible = false;
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(13, 222);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(75, 40);
            this.button1.TabIndex = 10;
            this.button1.Text = "Powi z tabel";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // button2
            // 
            this.button2.Location = new System.Drawing.Point(188, 222);
            this.button2.Name = "button2";
            this.button2.Size = new System.Drawing.Size(75, 40);
            this.button2.TabIndex = 11;
            this.button2.Text = "Dodaj film";
            this.button2.Click += new System.EventHandler(this.button2_Click);
            // 
            // button3
            // 
            this.button3.Location = new System.Drawing.Point(288, 222);
            this.button3.Name = "button3";
            this.button3.Size = new System.Drawing.Size(90, 40);
            this.button3.TabIndex = 12;
            this.button3.Text = "Aktualizuj baz danych";
            this.button3.Click += new System.EventHandler(this.button3_Click);
            // 
            // button5
            // 
            this.button5.Location = new System.Drawing.Point(101, 222);
            this.button5.Name = "button5";
            this.button5.Size = new System.Drawing.Size(75, 40);
            this.button5.TabIndex = 13;
            this.button5.Text = "Powi z tablic";
            this.button5.Click += new System.EventHandler(this.button5_Click);
            // 
            // textBox1
            // 
            this.textBox1.AutoSize = false;
            this.textBox1.Location = new System.Drawing.Point(105, 37);
            this.textBox1.Multiline = true;
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(80, 20);
            this.textBox1.TabIndex = 0;
            // 
            // pictureBox1
            // 
            this.pictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pictureBox1.Location = new System.Drawing.Point(105, 112);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(80, 84);
            this.pictureBox1.TabIndex = 6;
            this.pictureBox1.TabStop = false;
            // 
            // textBox2
            // 
            this.textBox2.AutoSize = false;
            this.textBox2.Location = new System.Drawing.Point(105, 62);
            //this.textBox2.Margin = new System.Windows.Forms.Padding(3, 3, 3, 1);
            this.textBox2.Multiline = true;
            this.textBox2.Name = "textBox2";
            this.textBox2.Size = new System.Drawing.Size(80, 20);
            this.textBox2.TabIndex = 8;
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(7, 37);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(0, 0);
            this.label4.TabIndex = 9;
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(7, 62);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(0, 0);
            this.label6.TabIndex = 10;
            // 
            // checkBox1
            // 
            //this.checkBox1.AutoSize = true;
            this.checkBox1.Location = new System.Drawing.Point(105, 88);
            //this.checkBox1.Margin = new System.Windows.Forms.Padding(3, 1, 3, 3);
            this.checkBox1.Name = "checkBox1";
            this.checkBox1.Size = new System.Drawing.Size(85, 17);
            this.checkBox1.TabIndex = 11;
            this.checkBox1.Text = "Najlepszy film";
            // 
            // button4
            // 
            this.button4.Location = new System.Drawing.Point(10, 170);
            this.button4.Name = "button4";
            this.button4.Size = new System.Drawing.Size(63, 25);
            this.button4.TabIndex = 12;
            this.button4.Text = "Przewi";
            this.button4.Click += new System.EventHandler(this.button4_Click);
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.label5);
            this.groupBox2.Controls.Add(this.label2);
            this.groupBox2.Controls.Add(this.button4);
            this.groupBox2.Controls.Add(this.checkBox1);
            this.groupBox2.Controls.Add(this.label6);
            this.groupBox2.Controls.Add(this.label4);
            this.groupBox2.Controls.Add(this.textBox2);
            this.groupBox2.Controls.Add(this.pictureBox1);
            this.groupBox2.Controls.Add(this.textBox1);
            this.groupBox2.Location = new System.Drawing.Point(288, 13);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(200, 202);
            this.groupBox2.TabIndex = 9;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Proste wizanie";
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(10, 65);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(29, 14);
            this.label5.TabIndex = 14;
            this.label5.Text = "rok";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(10, 37);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(38, 14);
            this.label2.TabIndex = 13;
            this.label2.Text = "wytwrnia";
            // 
            // button7
            // 
            this.button7.Location = new System.Drawing.Point(397, 222);
            this.button7.Name = "button7";
            this.button7.Size = new System.Drawing.Size(90, 40);
            this.button7.TabIndex = 15;
            this.button7.Text = "Poka zmiany";
            this.button7.Click += new System.EventHandler(this.button7_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(512, 274);
            this.Controls.Add(this.button7);
            this.Controls.Add(this.button5);
            this.Controls.Add(this.button3);
            this.Controls.Add(this.button2);
            this.Controls.Add(this.button1);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.groupBox1);
            this.Name = "Form1";
            this.Text = "Wizanie danych";
        }


        // Punkt wejcia aplikacji		 
        [STAThread]
        static void Main()
        {
            Application.Run(new Form1());
        }
        private string GetString()
        {
            string path = @"filmy.mdb";
            string strConn = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + path + ";";
            return strConn;
        }



        private string GetConnection()
        {
            string connstr = "server=DELL4300-SCP;uid=movieadmin;pwd=bogart;database=films;";
            return connstr;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // Tworzenie tabeli i wizanie z ni kontrolek listbox oraz combobox
            // Do dostpu do pliku z baz danych Access suy poczenie OleDb
            string strConn = GetString();
            OleDbConnection conn = new OleDbConnection(strConn);
            IDbCommand cmd = new OleDbCommand();
            cmd.Connection = conn;
            conn.Open();
            try
            {
                // Jeli uywana jest baza Sql Server, naley uy:
                // SqlConnection conn = new 
                // sqlConnection("server=DELL4300-SCP;uid=movieadmin;pwd=bogart;database=films;");
                // conn.Open();
                // string sql = "select movie_ID, movie_title, movie_year, movie_director, studio, afi_rank,                                // CASE WHEN bestpicture ='Y' then 1 else 0 END as BestPicture from movies order by movie_Title";
                // da = new SqlDataAdapter(sql, conn);
                // SqlCommandBuilder sb = new SqlCommandBuilder(da);       
                ds = new DataSet("films");
                // Warto zwrci uwag na skadni generujc 0 lub 1 do oznaczenia tego, czy film dosta Oskara
                string sql = "select movie_ID, movie_title, movie_year, movie_director, studio, afirank,                    if([BESTPICTURE]='Y',1,0) AS BestPicture from movies order by movie_Title";
                da = new OleDbDataAdapter(sql, conn);
                OleDbCommandBuilder sb = new OleDbCommandBuilder(da);
                da.Fill(ds, "movies");
                DataTable dt = ds.Tables["movies"];
                DataColumn dCol;
                dCol = new DataColumn("movie_Image", Type.GetType("System.Object"));
                dt.Columns.Add(dCol);
                // Umieszczanie rysunku w nowej kolumnie
                Image defaultImage = Image.FromFile(@"c:\defaultimg.jpg");
                foreach (DataRow dRow in dt.Rows)
                {
                    string rank = ((int)dRow["afirank"]).ToString();
                    string imgFile = "c:\\afi" + rank + ".gif";
                    if (File.Exists(imgFile))
                    {
                        Image imgObject = Image.FromFile(imgFile);
                        dRow["movie_Image"] = imgObject;
                    }
                    else dRow["movie_Image"] = defaultImage;
                }
                // Nic do tego miejsca nie naley uwaa za zmian
                dt.AcceptChanges();
                // Wizanie kontrolek listbox i combobox ze rdem danych
                listBox1.DataSource = ds;
                listBox1.DisplayMember = "movies.movie_title";
                listBox1.ValueMember = "movies.movie_ID";
                comboBox1.DataSource = ds;
                comboBox1.DisplayMember = "movies.movie_title";

            }
            catch (Exception ex)
            { MessageBox.Show(ex.Message); }
            // Meneder wizania ma zasig globalny
            bmb = this.BindingContext[ds, "movies"];
            bmb.PositionChanged += new EventHandler(bmb_PositionChanged);
            try
            {
                // Proste wizanie
                if (textBox1.DataBindings["text"] != null)
                    textBox1.DataBindings.Remove(textBox1.DataBindings["Text"]);
                textBox1.DataBindings.Add("text", ds, "movies.studio");

                if (textBox2.DataBindings["text"] != null)
                    textBox2.DataBindings.Remove(textBox2.DataBindings["Text"]);
                textBox2.DataBindings.Add("text", ds, "movies.movie_year");

                // Ten kod dziaa z SQL Server 
                if (checkBox1.DataBindings["Checked"] != null)
                    checkBox1.DataBindings.Remove(checkBox1.DataBindings["Checked"]);
                checkBox1.DataBindings.Add("Checked", ds, "movies.BestPicture");

                if (pictureBox1.DataBindings["BackgroundImage"] != null)
                    pictureBox1.DataBindings.Remove(pictureBox1.DataBindings["BackgroundImage"]);
                pictureBox1.DataBindings.Add("BackgroundImage", ds, "movies.movie_Image");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        private void BindToArray()
        {
            movieList = new ArrayList();
            Image movieImg = Image.FromFile(@"c:\defaultimg.jpg");
            movieList.Add(new MyMovie("2", "Casablanca", 1942, "Warner Bros.", true, Image.FromFile(@"c:\afi2.gif")));
            movieList.Add(new MyMovie("1", "Obywatel Kane", 1941, "RKO", false, Image.FromFile(@"c:\afi1.gif")));
            movieList.Add(new MyMovie("4", "Przemino z wiatrem", 1941, "Selznick International", true, Image.FromFile(@"c:\afi4.gif")));
            //
            listBox1.DataSource = movieList;
            listBox1.DisplayMember = "Movie_Title";

            bmb = this.BindingContext[movieList]; ;
            bmb.PositionChanged += new EventHandler(bmb_PositionChanged);
            comboBox1.DataSource = movieList;
            comboBox1.DisplayMember = "Movie_Title";
            if (textBox1.DataBindings["Text"] != null)
                textBox1.DataBindings.Remove(textBox1.DataBindings["Text"]);
            textBox1.DataBindings.Add("Text", movieList, "Studio");

            if (textBox2.DataBindings["Text"] != null)
                textBox2.DataBindings.Remove(textBox2.DataBindings["Text"]);
            textBox2.DataBindings.Add("Text", movieList, "Movie_Year");

            if (checkBox1.DataBindings["Checked"] != null)
                checkBox1.DataBindings.Remove(checkBox1.DataBindings["Checked"]);
            checkBox1.DataBindings.Add("Checked", movieList, "BestPicture");

            if (pictureBox1.DataBindings["BackgroundImage"] != null)
                pictureBox1.DataBindings.Remove(pictureBox1.DataBindings["BackgroundImage"]);
            pictureBox1.DataBindings.Add("BackgroundImage", movieList, "Movie_Image");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            // Dodanie flmu do listy. Mona zmieni ten fragment i umoliwi uytkownikowi wpisywanie danych filmu
            if (ds != null)
            {
                // Testowanie efektu dodania wiersza do tabeli
                DataTable dt = ds.Tables[0];
                DataRow dRow = dt.NewRow();
                dRow["movie_ID"] = 99;
                dRow["movie_Title"] = "Rear Window";
                dRow["movie_Year"] = "1954";
                dRow["studio"] = "Paramount";
                dRow["BestPicture"] = 0;
                dRow["afi_rank"] = 42;
                Image defaultImage = Image.FromFile(@"c:\afi42.gif");
                dRow["movie_Image"] = defaultImage;
            }
            else
            {
                Image movieImg = Image.FromFile(@"c:\afi42.gif");
                movieList.Add(new MyMovie("42", "Rear Window", 1954, "Paramount", false, movieImg));
                // Potrzebne w celu wywietlenia nowego filmu w kontrolkach ListBox i ComboBox
                CurrencyManager cm = (CurrencyManager)this.BindingContext[movieList];
                cm.Refresh();
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            try
            {
                int updates = da.Update(ds, "movies");
                MessageBox.Show(updates.ToString());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public class MyMovie
        {
            private string myID;
            private string myTitle;
            private int myYear;
            private string myStudio;
            private bool myBestPicture;
            private Image myImage;
            public event EventHandler Movie_YearChanged;
            public event EventHandler StudioChanged;
            public MyMovie(string id, string title, int year, string studio, bool bp, Image img)
            {
                myTitle = title;
                myYear = year;
                myStudio = studio;
                myBestPicture = bp;
                myImage = img;
                myID = id;
            }
            // Publiczne waciwoci mona wiza z kontrolkami
            public string Movie_Title { get { return myTitle; } }
            // Obie waciwoci s do odczytu i do zapisu, co umoliwia aktualizacj
            public int Movie_Year
            {
                get { return myYear; }
                set
                {
                    myYear = value;
                    if (Movie_YearChanged != null) Movie_YearChanged(this, EventArgs.Empty);
                }

            }
            public string Studio
            {
                get { return myStudio; }
                set
                {
                    myStudio = value;
                    if (StudioChanged != null) StudioChanged(this, EventArgs.Empty);
                }
            }
            public Image Movie_Image { get { return myImage; } }
            public bool BestPicture { get { return myBestPicture; } }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (listBox1.Items.Count > 0)
                bmb.Position = bmb.Position >= bmb.Count - 1 ? 0 : ++bmb.Position;
        }
        private void bmb_PositionChanged(object sender, EventArgs e)
        {
            // Przewijanie elementw w kontrolce ListBox1
            BindingManagerBase bmb = (BindingManagerBase)sender;
            string movieTitle;
            object ob = bmb.Current.GetType();
            if (ob == typeof(System.Data.DataRowView))
            {
                DataRowView view = (DataRowView)bmb.Current;
                movieTitle = (string)view["movie_Title"];
            }
            else
            {
                MyMovie movieObj = (MyMovie)bmb.Current;
                movieTitle = movieObj.Movie_Title;
            }
        }
        private bool DataReallyIsDirty(DataTable dt)
        {
            bool result = false;
            foreach (DataRow drw in dt.Rows)
            {
                if (drw.RowState == DataRowState.Modified)
                {
                    string msg = (string)drw["movie_Title"] + ":";
                    string curr;
                    string orig;
                    foreach (DataColumn col in dt.Columns)
                    {
                        curr = drw[col, DataRowVersion.Current].ToString().Trim();
                        orig = drw[col, DataRowVersion.Original].ToString().Trim();
                        if (!curr.Equals(orig) || curr != orig || string.CompareOrdinal(curr, orig) != 0)
                        {
                            msg += "\r\n" + orig + " " + curr;
                            result = true;
                        }
                    }
                }
            }
            return result;
        }

        private void button5_Click(object sender, EventArgs e)
        {
            // Wizanie z tablic
            BindToArray();
            ds = null;  // Moga zosta zaadowana wczeniej
        }

        private void button7_Click(object sender, EventArgs e)
        {
            if (ds != null)
            {
                DataTable dt = ds.Tables[0];
                if (!DataReallyIsDirty(dt))
                {
                    MessageBox.Show("Nie wprowadzono adnych zmian");
                }
            }
        }
    }

}