using System;
using System.ComponentModel;
using System.Data;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Data.OleDb;
using System.IO;
// Kompilacja: csc /t:winexe dbexamples.cs
// Przykad dostpu poczeniowego i bezpoczeniowego.
// Przykad wykorzystania obiektu CommandBuilder do aktualizacji bazy danych.
namespace datamodel
{
    public class Form1 : Form
    {
        private System.Windows.Forms.ListBox listBox1;
        private Button button1;
        private Button button2;
        private Button button3;
        private Button button4;
        private Label label1;
        private TextBox textBox1;
        private TextBox textBox2;
        private System.ComponentModel.IContainer components = null;
        bool Adapter;
        OleDbDataAdapter da;
        DataTable dt;
        DataSet ds;
        //
        public Form1()
        {
            InitializeComponent();
            listBox1.SelectedIndexChanged += new EventHandler(listBox1_SelectedIndexChanged);
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        private void InitializeComponent()
        {
            this.listBox1 = new System.Windows.Forms.ListBox();
            button1 = new Button();
            button2 = new Button();
            textBox1 = new TextBox();
            textBox2 = new TextBox();
            button3 = new Button();
            button4 = new Button();
            label1 = new Label();
            // 
            // listBox1
            // 
            //this.listBox1.FormattingEnabled = true;
            this.listBox1.Location = new System.Drawing.Point(16, 47);
            this.listBox1.Name = "listBox1";
            this.listBox1.Size = new System.Drawing.Size(100, 121);
            this.listBox1.TabIndex = 1;
            this.Controls.Add(listBox1);
            // textBox1
            //
            this.textBox1.Location = new System.Drawing.Point(126, 47);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(60, 22);
            this.textBox1.TabIndex = 1;
            this.Controls.Add(textBox1);
            // textBox2
            //
            this.textBox2.Location = new System.Drawing.Point(122, 77);
            this.textBox2.Name = "textBox1";
            this.textBox2.Size = new System.Drawing.Size(160, 90);
            this.textBox2.TabIndex = 1;
            textBox2.Multiline = true;
            textBox2.ScrollBars = ScrollBars.Vertical;
            this.Controls.Add(textBox2);
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(13, 202);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(90, 23);
            this.button1.TabIndex = 2;
            this.button1.Text = "DataReader";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            this.Controls.Add(button1);
            // 
            // button2
            // 
            this.button2.Location = new System.Drawing.Point(13, 178);
            this.button2.Name = "button2";
            this.button2.Size = new System.Drawing.Size(90, 23);
            this.button2.TabIndex = 3;
            this.button2.Text = "DataAdapter";
            this.button2.Click += new System.EventHandler(this.button2_Click);
            this.Controls.Add(button2);
            this.Name = "Form1";
            this.Text = "DataReader/Data Adapter";
            // 
            // button3
            // 
            this.button3.Location = new System.Drawing.Point(190, 47);
            this.button3.Name = "button2";
            this.button3.Size = new System.Drawing.Size(83, 23);
            this.button3.TabIndex = 4;
            this.button3.Text = "Zmie dane";
            this.button3.Click += new System.EventHandler(this.button3_Click);
            this.Controls.Add(button3);
            // 
            // button4
            // 
            this.button4.Location = new System.Drawing.Point(132, 178);
            this.button4.Name = "button4";
            this.button4.Size = new System.Drawing.Size(150, 23);
            this.button4.TabIndex = 5;
            this.button4.Text = "Relacje reyser-film";
            this.button4.Click += new System.EventHandler(this.button4_Click);
            this.Controls.Add(button4);

            this.label1.Location = new System.Drawing.Point(16, 20);
            this.label1.Name = "button2";
            this.label1.Size = new System.Drawing.Size(83, 23);
            this.label1.Text = " ";
            this.Controls.Add(label1);

            this.Name = "Form1";
            this.Text = "DataReader/Data Adapter";
        }


        // Punkt wejcia aplikacji.	 
        [STAThread]
        static void Main()
        {
            Application.Run(new Form1());
        }
        private string GetConnection()
        {
            string path = "filmy.mdb";
            string strConn = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + path + ";";
            return strConn;
        }

        private string GetConnection1()
        {
            // SQL Server
            string connstr = "server=DELL4300-SCP;uid=movieadmin;pwd=bogart;database=films;";
            return connstr;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // Przykad wykorzystujcy obiekt DataReader.
            // Poczenie z plikiem z baz danych Access

            Adapter = false;
            label1.Text = "DataReader";
            textBox1.Text = "";
            string strConn = GetConnection();
            OleDbConnection conn = new OleDbConnection(strConn);
            OleDbCommand cmd = new OleDbCommand();
            cmd.Connection = conn;
            conn.Open();
            // (2) acuch znakw zapytania
            string sql = "SELECT movie_Title , movie_Year FROM movies ORDER BY movie_Year";
            // (3) Tworzenie obiektu Command
            cmd.CommandText = sql;
            OleDbDataReader rdr;
            // (4) Tworzenie obiektu DataReader
            rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            listBox1.Items.Clear();
            try
            {
                while (rdr.Read())
                {
                    listBox1.Items.Add(rdr["movie_Title"]);  // Fill ListBox
                }
            }
            catch (Exception ex)
            { MessageBox.Show(ex.Message); }
            conn.Close();
            rdr.Close();
        }


        private void button2_Click(object sender, EventArgs e)
        {
            // Przykad wykorzystujcy obiekt DataAdapter
            Adapter = true;
            label1.Text = "DataAdapter";
            textBox1.Text = "";
            ds = new DataSet();
            OleDbConnection conn = new OleDbConnection(GetConnection());
            conn.Open();
            string sql = "SELECT movie_ID, movie_Title, movie_Year FROM movies ORDER BY movie_Title";
            da = new OleDbDataAdapter(sql, conn);
            da.ContinueUpdateOnError = false;
            da.Fill(ds, "movies");
            dt = ds.Tables["movies"];
            // Zwykle uywa si w takiej sytuacji wizania danych
            listBox1.Items.Clear();
            try
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    DataRow row = dt.Rows[i];
                    listBox1.Items.Add(row["movie_Title"]);
                }

            }
            catch (Exception ex)
            { MessageBox.Show(ex.Message); }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            // Test aktualizujcy rekord w bazie danych za pomoc obiektu CommandBuilder
            OleDbCommandBuilder sb = new OleDbCommandBuilder(da);
            int ndx = listBox1.SelectedIndex;
            if (ndx >= 0 && textBox1.Text.Trim() != "")
            {
                dt.Rows[ndx]["movie_Year"] = textBox1.Text;
                try
                {
                    // Ostronie! Ponisza instrukcja wprowadza zmiany w oryginalnej bazie danych
                    int updates = da.Update(ds, "movies");
                    MessageBox.Show("Zmienione wiersze: " + updates.ToString());
                }
                catch (Exception ex)
                { MessageBox.Show(ex.Message); }
            }
            // failures to obiekt DataSet zawierajcy nieudane aktualizacje wierszy
            if (ds.HasChanges())
            {
                // adowanie bdnych wierszy do obiektu DataSet
                DataSet failures = ds.GetChanges();
                int rowsFailed = failures.Tables[0].Rows.Count;
                MessageBox.Show("Nieudane aktualizacje: " + rowsFailed.ToString());
            }

        }

        private void button4_Click(object sender, EventArgs e)
        {
            // Tworzenie relacji midzy bazami directors i movies
            DataSet ds = new DataSet();
            string sql = "select movie_ID,movie_Title,movie_DirectorID, movie_Year from  movies";
            string connStr = GetConnection();
            OleDbConnection conn = new OleDbConnection(connStr);
            OleDbCommand cmd = new OleDbCommand();
            OleDbDataAdapter da = new OleDbDataAdapter(sql, conn);
            da.Fill(ds, "movies");
            //
            da.SelectCommand.CommandText = "select director_id,(first_name + ' '+ last_name) as fullname, first_name, last_name from directors";
            da.Fill(ds, "directors");
            //
            DataTable parent = ds.Tables["directors"];
            DataTable child = ds.Tables["movies"];
            MessageBox.Show("Reyserzy: " + parent.Rows.Count.ToString());
            MessageBox.Show("Filmy: " + child.Rows.Count.ToString());
            DataRelation relation = new DataRelation("directormovies",
                parent.Columns["director_ID"],
                child.Columns["movie_DirectorID"]);
            ds.Relations.Add(relation);
            string list = "";
            foreach (DataRow r in parent.Rows)
            {
                list = list + r["fullname"] + "\r\n";
                // list = list+r["first_name"]+" "+ r["last_name"]+"\r\n";
                foreach (DataRow rc in r.GetChildRows("directormovies"))
                {
                    list = list + "  " + rc["movie_title"] + "\r\n";
                }
            }
            textBox2.Text = list;
        }

        private void listBox1_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            // Pobiera aktualnie zaznaczony element kontrolki ListBox.
            string curItem = listBox1.SelectedItem.ToString();
            if (Adapter)
            {
                int ndx = listBox1.SelectedIndex;
                textBox1.Text = (dt.Rows[ndx]["Movie_Year"]).ToString();
            }
        }
    }
}