using System;
using System.Xml;
using System.Xml.XPath;
using System.Data;
using System.Xml.Serialization;
using System.IO;
using System.Data.OleDb;
using System.Xml.Xsl;
using System.Text;
// compile: csc xmlserializer.cs
public class XmlReaderSample
{
	public class movies
	{       
		private int mID;
		private string mTitle;
		private int mYear;
		private string mDirector;
		private string mbestPicture;
		private int mAFIRank;  
		private string mstudio;
		public movies()
		{   }
		public movies(int ID, string title, string dir,string pic,int yr, int movierank, string moviestudio)
		{
			movieID= ID;
			movie_Director= dir;
			bestPicture= pic;
			rank= movierank;
			movie_Title= title;     
			movie_Year = yr;
			studio = moviestudio;
		}
		public int movieID
		{  	get { return mID; }
			set { mID = value; }
		}   
		public string movie_Title
		{
			get { return mTitle; }
			set { mTitle = value; }
		}
		public int movie_Year
		{  
			get { return mYear; }
			set { mYear = value; }
		}    
		public string movie_Director
		{  
			get { return mDirector; }
			set { mDirector = value; }
		}
		public string bestPicture
		{  
			get { return mbestPicture; }
			set { mbestPicture = value; }
		}
		public string studio
		{  
			get { return mstudio; }
			set { mstudio = value; }
		}       
		[XmlElement("AFIRank")]
		public int rank
		{  
			get { return mAFIRank; }
			set { mAFIRank = value; }
		}
	}
	private static string GetString()
	{
		string path =  @"\filmy.mdb"  ;
		string strConn= @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source="+path+";";
		return strConn;
	}    

   
	public static void Main()
	{
		/*  Zamiast bazy danych systemu Access moglibymy uy tablicy:
		movies[] films = {new movies(5,"Obywatel Kane","Orson Welles","Y", 1941,1,"RKO" ),
						  new movies(6,"Casablanca","Michael Curtiz","Y", 1942,2,"Warner Bros.")};
		*/
		// Wczytuje informacje o filmach z pliku systemu baz danych Access.
		string strConn= GetString();
		OleDbConnection conn = new OleDbConnection(strConn);      
		OleDbCommand cmd = new OleDbCommand();       
		cmd.Connection= conn;
		conn.Open();       
		// Uzyskuje liczb filmw i na tej podstawie okrela rozmiar tworzonej tablicy.
		cmd.CommandText= "select count(*) from movies where bestpicture='Y'";
		int winnerCt = (int)cmd.ExecuteScalar();
		movies[] films = new movies[winnerCt];
		// Wykonuje zapytanie zwracajce list filmw oskarowych.
		cmd.CommandText= "select * from movies where bestpicture='Y' order by afirank";
		OleDbDataReader rdr= cmd.ExecuteReader();
		int row=0;
		while(rdr.Read())
		{
			films[row]= new movies(row, (string)rdr["movie_title"], (string)rdr["movie_director"],(string)rdr["bestpicture"],
								   (int)rdr["movie_year"],(int)rdr["afirank"],(string)rdr["studio"]);          
			row +=1;        
		}
		rdr.Close();
		conn.Close();
        
		XmlRootAttribute xRoot = new XmlRootAttribute();
		xRoot.ElementName = "films";
		xRoot.Namespace = "http://www.helion.pl";
		xRoot.IsNullable = true;

		// Konstruuje obiekt klasy XmlSerializer z wykorzystaniem obiektu klasy XmlRootAttribute.
		XmlSerializer xSerial = new XmlSerializer(typeof(movies[]),xRoot);        
		//string filename=@"\movieserial.xml";
		string filename=@"\filmy oskarowe.xml";
		TextWriter writer = new StreamWriter(filename);
		// Serializuje obiekt do strumienia XML za pomoc obiektu klasy TextWriter.
		xSerial.Serialize(writer,films);
		writer.Close();

		Console.WriteLine("{0} filmw reprezentowanych w "+filename,row);
		// Sprawdza zgodno kodu XML ze schematem.
		// Aby utworzy odpowiedni schemat, uruchom program xsd.exe.
		if(ValidateSchema(@"\filmy oskarowe.xml", @"\filmy oskarowe.xsd"))
		{
			Console.WriteLine("\r\nDokument XML sprawdzony");          
		}	

		Console.Read();
	}   

	private static bool ValidateSchema(string xml, string xsd)
	{
		// (1) Tworzy obiekt odczytujcy obsugujcy weryfikacj dokumentu XML.
		XmlTextReader tr = new XmlTextReader(xml);
		XmlValidatingReader xvr = new XmlValidatingReader(tr);
		// (2) Okrela, e dokument ma by sprawdzany pod ktem zgodnoci ze schematem.
		xvr.ValidationType= ValidationType.Schema;
		// (3) Dodaje schemat, ktry zostanie uyty w procesie sprawdzania poprawnoci.
		xvr.Schemas.Add(null, xsd);
		try
		{
			Console.Write("Weryfikacja: ");
			// Przeszukuje iteracyjnie wszystkie elementy danego dokumentu XML.
			while(xvr.Read())
			{
				Console.Write(".");
			}		   
		}catch (Exception ex)
		{ Console.WriteLine( "\n{0}",ex.Message); return false;}    
		Console.Write("\nPlik jest zgodny ze schematem.\n");		
		return true;
	}

	private static void SerializeActors()
	{
		actorTable[] actors = new actorTable[950];
		string strConn= GetString();
		OleDbConnection conn = new OleDbConnection(strConn);      
		OleDbCommand cmd = new OleDbCommand();       
		cmd.Connection= conn;
		conn.Open();              
		cmd.CommandText= "select * from actors";
		OleDbDataReader rdr= cmd.ExecuteReader();
		int row=0;
		while(rdr.Read())
		{
			actors[row]= new actorTable((int)rdr["actor_id"], (string)rdr["actor_name"], (string)rdr["actor_sex"],(string)rdr["actor_last"],
								   (string)rdr["actor_first"]);          
			row +=1;        
		}
		rdr.Close();
		conn.Close();
        
		XmlRootAttribute xRoot = new XmlRootAttribute();
		xRoot.ElementName = "actors";
		xRoot.Namespace = "http://www.helion.pl";
		xRoot.IsNullable = true;

		// Konstruuje obiekt klasy XmlSerializer z wykorzystaniem obiektu klasy XmlRootAttribute.
		XmlSerializer xSerial = new XmlSerializer(typeof(actorTable[]),xRoot);        
		string filename=@"c:\filmy.aktorzy.xml";
		TextWriter writer = new StreamWriter(filename);
		// Serializuje obiekt do strumienia XML.
		xSerial.Serialize(writer,actors);
		writer.Close();		
		Console.WriteLine("{0} aktorw reprezentowanych w filmy.aktorzy.xml",row);
	}


	private static void SerializeActorLink()
	{
		bool err=false;
		actorLink[] actors = new actorLink[1100];
		string strConn= GetString();
		OleDbConnection conn = new OleDbConnection(strConn);      
		OleDbCommand cmd = new OleDbCommand();       
		cmd.Connection= conn;
		conn.Open();              
		cmd.CommandText= "select * from actor_movie";
		OleDbDataReader rdr= cmd.ExecuteReader();
		int row=0;
		try
		{
			while(rdr.Read())
			{
				actors[row]= new actorLink((int)rdr["actor_id"], (int)rdr["movie_id"]);          
				row +=1;      			 
			}
		}catch (Exception ex)
		{Console.WriteLine(ex.Message); err=true;}
		rdr.Close();
		conn.Close();
		if(!err)
		{
			XmlRootAttribute xRoot = new XmlRootAttribute();
			xRoot.ElementName = "actormovie";
			xRoot.Namespace = "http://www.helion.pl";
			xRoot.IsNullable = true;
			// Konstruuje obiekt klasy XmlSerializer z wykorzystaniem obiektu klasy XmlRootAttribute.
			XmlSerializer xSerial = new XmlSerializer(typeof(actorLink[]),xRoot);        
			string filename=@"c:\filmy.aktorzyfilmy.xml";
			TextWriter writer = new StreamWriter(filename);
			// Serializuje obiekt do strumienia XML.
			xSerial.Serialize(writer,actors);
			writer.Close();		
			Console.WriteLine("{0} aktorw reprezentowanych w filmy.aktorzyfilmy.xml",row);
		}
	}
	// Klasa obsugujca tworzenie rekordw reprezentujcych aktorw.
	public class actorTable
	{       
		private int aID;
		private string aName;
		private string aSex;
		private string aLast;
		private string aFirst;
		public actorTable()
		{   }
		public actorTable(int ID, string name, string sex, string last, string first) 
		{
			aID= ID;
			aName = name;
			aSex = sex;
			aLast = last;
			aFirst = first;     
		}
		public int actor_ID
		{  
			get { return aID; }
			set { aID = value; }
		}   
		public string actor_Name
		{
			get { return aName; }
			set { aName = value; }        
		}	
		public string actor_Last
		{
			get { return aLast; }
			set { aLast = value; }        
		}	
		public string actor_First
		{
			get { return aFirst; }
			set { aFirst = value; }        
		}	  
		public string actor_Sex
		{
			get { return aSex; }
			set { aSex = value; }        
		}	     
	}
    
	public class actorLink
	{       
		private int aID;
		private int aMovieID;       
		public actorLink()
		{   }
		public actorLink(int actorID, int movieID) 
		{
			aID= actorID;
			aMovieID = movieID;
		}
		public int actor_ID
		{  
			get { return aID; }
			set { aID = value; }
		}   
		public int movie_ID
		{
			get { return aMovieID; }
			set { aMovieID = value; }        
		}	   
	}
}   