using System;
using System.Drawing;	
using System.Drawing.Printing;
using System.Windows.Forms;
// Poniszy kod moe by wykorzystywany w roli szablonu dla aplikacji drukujcych.
class PrintApp
{
  static void Main() 
  {
     // Tworzy i wywouje nowy formularz.
     Application.Run(new PrintForm());  
  }
}
 
class PrintForm:Form
{
 	// Konstruktor
 	public PrintForm() 
 	{
	 	Button btnPrint = new Button();
	 	btnPrint.Text="Drukuj";
	 	btnPrint.Location= new Point(100,60);
		this.Controls.Add(btnPrint);
		btnPrint.Click += new EventHandler(btnPrint_Click);	
		this.Text="Przykad aplikacji drukujcej";
		this.Height= 200;
	}	
	
	// Obsuguje zdarzenie kliknicia przycisku.
 	private void btnPrint_Click(object sender, System.EventArgs e)
	{ 
		PrintReport();
	}
	// Konfiguruje rodowisko drukowania.
 	private void PrintReport() 
	{
		// (1) Tworzy obiekt klasy PrintDocument.
		PrintDocument pd = new PrintDocument();
		// (2) Tworzy obiekt klasy PrintDialog.
		PrintDialog pDialog = new PrintDialog();
		pDialog.Document = pd;
		// (3) Tworzy obiekt klasy PrintPreviewDialog.
		PrintPreviewDialog prevDialog = new PrintPreviewDialog();
		prevDialog.Document = pd;
		// (4) Przypisuje metod obsugujc do zdarzenia PrintPage.
		pd.PrintPage += new PrintPageEventHandler(Inven_Report);
		// (5) Wywietla okno dialogowe drukowania i drukuje w odpowiedzi na nacinicie przycisku OK.
		if (pDialog.ShowDialog()== DialogResult.OK) 
		{
			pd.Print(); // Wywouje zdarzenie PrintPage.
		}
	 }
	 private void Inven_Report(object sender, PrintPageEventArgs e)
	 {
		Graphics g = e.Graphics;
		Font myFont = new Font("Arial",10);
		g.DrawString("Przykadowe dane wyjciowe",myFont,Brushes.Black,10,10);
		myFont.Dispose();
	 }
}