using System;
using System.Drawing;
using System.Drawing.Text;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Drawing.Printing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Data.SqlClient;
using System.Data.OleDb;
// Niestandardowa klasa PrintDocument, ktra wykorzystuje dane zawarte w bazie danych katalog.mdb.
namespace printer
{
	// Przykad uycia klasy Print.
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnPrint;
		int currPg = 1;
		int maxPg;
		Font rptFont;
		Font hdrFont;
		float lineHeight;
		string title= "Salon meblowy: Raport o oferowanych produktach";
		SqlDataReader dr;
		private StreamReader sr;
		string[]prtLine;
		private System.Windows.Forms.ListBox printerList;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Button button7;
		private CheckBox preview;
		// Zmienna wymagana przez modu projektowania.
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();			
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code

		private void InitializeComponent()
		{			 
			this.btnPrint = new System.Windows.Forms.Button();
			this.printerList = new System.Windows.Forms.ListBox();
			this.button4 = new System.Windows.Forms.Button();
			this.button7 = new System.Windows.Forms.Button();			
			// 
			// btnPrint
			// 
			this.btnPrint.Location = new System.Drawing.Point(140, 20);
			this.btnPrint.Name = "btnPrint";
			this.btnPrint.Size = new System.Drawing.Size(84, 24);
			this.btnPrint.TabIndex = 2;
			this.btnPrint.Text = "Drukuj raport";
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			// 
			preview = new CheckBox();
			preview.Location = new Point(250,20);
			preview.Text="Tylko podgld";
			preview.Checked=true;
			
			// 
			// printerList
			// 
			this.printerList.Location = new System.Drawing.Point(8, 12);
			this.printerList.Name = "printerList";
			this.printerList.Size = new System.Drawing.Size(124, 100);
			this.printerList.TabIndex = 3;
			// 
			// button4
			// 
			this.button4.Location = new System.Drawing.Point(12, 120);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(84, 24);
			this.button4.TabIndex = 1;
			this.button4.Text = "Lista drukarek";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// button7
			// 
			this.button7.Location = new System.Drawing.Point(140, 60);
			this.button7.Name = "button7";
			this.button7.Size = new System.Drawing.Size(90, 24);
			this.button7.TabIndex = 5;
			this.button7.Text = "Wydruk niestandardowy";
			this.button7.Click += new System.EventHandler(this.button7_Click);
			// 
			// Form1
			// 			
			this.Height=220;
			this.Width= 340;
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button7,
																		  this.button4,
																		  this.printerList,
																		  this.btnPrint,
																		  this.preview});
			this.Name = "Form1";
			this.Text = "Drukowanie raportw";
			this.ResumeLayout(false);
		}
		#endregion

		 
		// Gwny punkt startu tej aplikacji.		 
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private string GetString()
        {
        	string path =  @"\katalog.mdb"  ;
   			string strConn= @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source="+path+";";
   			return strConn;
 		}           
       
       		
		private void btnPrint_Click(object sender, System.EventArgs e)
		{			
			PrintReport();
		}
		
		private void PrintReport() 
		{
			// (1) Tworzy obiekt klasy PrintDocument.
			PrintDocument pd = new PrintDocument();
			// (2) Tworzy obiekt klasy PrintDialog.
			PrintDialog pDialog = new PrintDialog();
			pDialog.Document = pd;
			// (3) Tworzy obiekt klasy PrintPreviewDialog.
			PrintPreviewDialog prevDialog = new PrintPreviewDialog();
			prevDialog.Document = pd;
			// (4) Wie okrelon metod obsugujc ze zdarzeniem PrintPage.
			pd.PrintPage += new PrintPageEventHandler(Inven_Report);
			pd.BeginPrint += new PrintEventHandler(Rpt_BeginPrint);
			pd.EndPrint   += new PrintEventHandler(Rpt_EndPrint);
			//pd.QueryPageSettings += new QueryPageSettingsEventHandler(Rpt_Query);
			// (5) Wywietla okno dialogowe drukowania i drukuje raport w odpowiedzi na kliknicie przycisku OK.
			pDialog.AllowSomePages = true;
			pDialog.AllowSelection = true;
			pd.PrinterSettings.FromPage =1;
			pd.PrinterSettings.MinimumPage=1;
			pd.PrinterSettings.MaximumPage= 5;
			pd.PrinterSettings.ToPage=1;
			if (pDialog.ShowDialog()== DialogResult.OK) 
			{
				prevDialog.ShowDialog();
				//PageSetupDialog ps = new PageSetupDialog();
				//ps.Document = pd;
				//ps.ShowDialog();
				//
				string metrics="";
				metrics= "left margin:"+pd.DefaultPageSettings.Margins.Left.ToString();
				metrics= metrics + "\nright margin "+pd.DefaultPageSettings.Margins.Right.ToString();
				metrics= metrics + "\ntop margin "+pd.DefaultPageSettings.Margins.Top.ToString();
				metrics= metrics + "\npaper height "+pd.DefaultPageSettings.PaperSize.Height.ToString();
				metrics= metrics + "\npaper width "+pd.DefaultPageSettings.PaperSize.Width.ToString();
				metrics= metrics + "\nbounds width "+pd.DefaultPageSettings.Bounds.Width.ToString();
				metrics= metrics + "\npaper name "+pd.DefaultPageSettings.PaperSize.PaperName;
				metrics= metrics + "\nresolution: "+pd.DefaultPageSettings.PrinterResolution.Kind.ToString();
				MessageBox.Show(metrics);
				maxPg = 5;
				currPg= 1;
				if (pDialog.PrinterSettings.PrintRange == PrintRange.SomePages)
				{
					currPg = pd.PrinterSettings.FromPage;
					maxPg  = pd.PrinterSettings.ToPage;
				}
				// Teraz nastepuje fizyczny proces drukowania.
				if(!preview.Checked) pd.Print(); // Wywouje zdarzenie PrintPage.
			}
		}
		private void Inven_Report(object sender, PrintPageEventArgs e)
		{
			Graphics g = e.Graphics;			
			lineHeight = hdrFont.GetHeight(g);			
			int xpos= e.MarginBounds.Left;
			int lineCt = 0;
			int linesPerPage =(int)( (e.MarginBounds.Bottom - e.MarginBounds.Top)/lineHeight -2);
			float yPos = 2* lineHeight+ e.MarginBounds.Top;
			int hdrPos = e.MarginBounds.Top;
			PrintHdr(g,hdrPos, e.MarginBounds.Left);  // Drukuje nagwek kolumny.
			string prod;
			char[]delim=  {','};
			while((  prod =sr.ReadLine())!=null)
			{
				prtLine= prod.Split(delim,4);
				yPos += lineHeight;
				PrintDetail(g,yPos);
				if(lineCt > linesPerPage)
				{
					e.HasMorePages= true;
					break;
				}
			}			
		}
		private void PrintHdr( Graphics g, int yPos, int xPos) 
		{
			// Wywietla tytu raportu.
			g.DrawString(title,hdrFont,Brushes.Black,xPos,yPos);
			// Wywietla tytu kolumny.
			float[] ts = {80, 80,200};
			StringFormat strFmt = new StringFormat();
			strFmt.SetTabStops(0,ts);
			g.DrawString("Code\tVendor\tDescription\tCost",hdrFont,Brushes.Black,xPos,yPos+2*lineHeight,strFmt);
        }
		private void PrintDetail(Graphics g, float yPos)
		{
			int xPos = 100;
			StringFormat strFmt = new StringFormat();
			strFmt.Trimming = StringTrimming.EllipsisCharacter;
			strFmt.FormatFlags = StringFormatFlags.NoWrap;
			RectangleF r = new RectangleF(xPos+160,yPos,200,lineHeight);
			
			/* ten fragment byby uywany w przypadku rekordw z bazy danych
			string invenid = dr.GetInt32(0).ToString();
			string vendor  = dr.GetString(1);
			string desc    = dr.GetString(2);
			decimal price  = dr.GetDecimal(3);
			*/
			string invenid = prtLine[0];
			string vendor = prtLine[1];
			string desc = prtLine[2];
			decimal price = decimal.Parse(prtLine[3]);
			g.DrawString(invenid, rptFont,Brushes.Black,xPos, yPos);
			g.DrawString(vendor, rptFont,Brushes.Black,xPos+80, yPos);
			g.DrawString(desc, rptFont,Brushes.Black,r,strFmt);
			strFmt.Alignment = StringAlignment.Far;
			strFmt.Trimming= StringTrimming.None;
			g.DrawString(price.ToString("# ###,00"),rptFont,Brushes.Black, xPos+400,yPos,strFmt);
		}
		private void Rpt_BeginPrint(object sender, PrintEventArgs e)
		{
			rptFont = new Font("Arial",10);
			hdrFont = new Font(rptFont,FontStyle.Bold);
			sr = new StreamReader("c:\\katalog.txt");			 
			/*
			StreamReader connfile;
			string connstr;
			connfile = new StreamReader("c:/poczenie/cigpoczenia.txt");
			connstr = connfile.ReadLine();
			connfile.Close();
			SqlConnection conn = new SqlConnection(connstr);
			SqlCommand cd = new SqlCommand();
			cd.Connection= conn;
			cd.CommandText= "select inventory_id, vendor_id, inven_desc, unit_cost from inventory where vendor_id = '1050'";
			conn.Open();			
			dr = cd.ExecuteReader();			
			*/
		}
		private void Rpt_EndPrint(object sender, PrintEventArgs e)
		{
			rptFont.Dispose();
			hdrFont.Dispose();
			sr.Close();			
		}
		
		private void button4_Click(object sender, System.EventArgs e)
		{
			// Generuje list dostpnych drukarek.
			foreach(string pName in PrinterSettings.InstalledPrinters)
				printerList.Items.Add(pName);			
		}		

		private void button7_Click(object sender, System.EventArgs e)
		{
			// Wykorzystuje niestandardow klas PrintDocument.
			ReportPrintDocument rpd = new ReportPrintDocument("Salon meblowy: Raport o oferowanych produktach");
			rpd.TitleFont = new Font("Arial",10, FontStyle.Bold);
			rpd.ReportFont = new Font("Arial",10);
           		rpd.ConnectionString = GetString();  // acuch poczenia.
			PrintPreviewDialog prevDialog = new PrintPreviewDialog();
			prevDialog.Document = rpd;
			prevDialog.ShowDialog();
			
			PrintDialog pDialog = new PrintDialog();
			pDialog.Document = rpd;
			if (pDialog.ShowDialog() == DialogResult.OK) 
			{
			//	rpd.Print();
			}
		  }		
		}		 
	}
	
	// Niestandardowa klasa potomna wzgldem klasy bazowej PrintDocument.
	public class ReportPrintDocument: PrintDocument
	{
		private Font hdrFont;
		private Font rptFont;
		private string title;
		private OleDbDataReader dr;
		private float lineHeight;
		private string connstr;
		public ReportPrintDocument()
		{}
		public ReportPrintDocument(string myTitle)
		{
			title = myTitle;
		}
		public string ConnectionString
		{
		    get {return connstr;}
		    set {connstr = value;}
		}
		public string ReportTitle
		{
			get {return title;}
			set {title = value;}
        }
		// Ustawia czcionki wykorzystywane w raporcie.
		public Font TitleFont
		{
			get {return hdrFont;}
			set {hdrFont = value;}
		}
		public Font ReportFont
		{
			get {return rptFont;}
			set {rptFont = value;}
		}
		protected override void OnBeginPrint(PrintEventArgs e)
		{
			base.OnBeginPrint(e);
			// Przypisuje czcionki.
			if (TitleFont == null) 
			{
				TitleFont = new Font("Arial",10,FontStyle.Bold);
				ReportFont = new Font("Arial",10);
			}
			// Ustawia obiekt klasy DataReader.
			//StreamReader connfile;
			//string connstr;
			//connfile = new StreamReader("c:/poczenie/cigpoczenia.txt");
			//connstr = connfile.ReadLine();
			//connfile.Close();
			/* Sql Server implementation  
			SqlConnection conn = new SqlConnection(connstr);
			SqlCommand cd      = new SqlCommand();
			*/
			OleDbConnection conn = new OleDbConnection(ConnectionString);      
			OleDbCommand cd = new OleDbCommand();  				         
	        //
			cd.Connection= conn;
			cd.CommandText= "select inventory_id, vendor_id, inven_desc, unit_cost from inventory where vendor_id = '1050'";
			conn.Open();
			dr = cd.ExecuteReader();	
		}
		protected override void OnEndPrint(PrintEventArgs e)
		{
			base.OnEndPrint(e);
			TitleFont.Dispose();
			ReportFont.Dispose();
			dr.Close();
		}
		protected override void OnPrintPage(PrintPageEventArgs e)
	    {
			base.OnPrintPage(e);
			Graphics g = e.Graphics;
			// Zwraca 15,97
			lineHeight = hdrFont.GetHeight(g);
			int xpos= e.MarginBounds.Left;
			int lineCt = 0;
			int linesPerPage =(int)( (e.MarginBounds.Bottom - e.MarginBounds.Top)/lineHeight -2);
			float yPos = 2* lineHeight+ e.MarginBounds.Top;
			int hdrPos = e.MarginBounds.Top;
			PrintHdr(g,hdrPos, e.MarginBounds.Left);  // Drukuje nagwki kolumn.
			while (dr.Read())
			{
				yPos += lineHeight;
				PrintDetail(g, yPos);				
				lineCt +=1;
				if (lineCt > linesPerPage) 
				{
					e.HasMorePages = true;
					break;
				}  
			}
		}
		private void PrintHdr( Graphics g, int yPos, int xPos) 
		{
			// Wywietla tytu raportu.
			g.DrawString(title,TitleFont,Brushes.Black,xPos,yPos);
			// Wywietla tytu kolumny.
			float[] ts = {80, 80,200};
			StringFormat strFmt = new StringFormat();
			strFmt.SetTabStops(0,ts);
			g.DrawString("Code\tVendor\tDescription\tCost",TitleFont,Brushes.Black,xPos,yPos+2*lineHeight,strFmt);
		}
		private void PrintDetail(Graphics g, float yPos)
		{
			int xPos = 100;
			StringFormat strFmt = new StringFormat();
			//strFmt.Alignment = StringAlignment.Far;
			strFmt.Trimming = StringTrimming.EllipsisCharacter;
			strFmt.FormatFlags = StringFormatFlags.NoWrap;
			RectangleF r = new RectangleF(xPos+160,yPos,200,lineHeight);
			string invenid = dr.GetInt32(0).ToString();
			string vendor  = dr.GetString(1);
			string desc    = dr.GetString(2);
			decimal price  = dr.GetDecimal(3);
			g.DrawString(invenid, rptFont,Brushes.Black,xPos, yPos);
			g.DrawString(vendor, rptFont,Brushes.Black,xPos+80, yPos);
			g.DrawString(desc, rptFont,Brushes.Black,r,strFmt);
			strFmt.Alignment = StringAlignment.Far;
			strFmt.Trimming= StringTrimming.None;
			g.DrawString(price.ToString("# ###,00"),rptFont,Brushes.Black, xPos+400,yPos,strFmt);
		}
	}