using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Drawing.Drawing2D;

namespace GDIredraw
{

	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.PictureBox pictureBox1;
		Rectangle rectNC;
		Rectangle rectSC;
		Rectangle rectGA;
		GraphicsPath gp;		 
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			InitializeComponent();
			this.panel1.Paint += new PaintEventHandler(paint_Form);
			this.pictureBox1.Paint += new PaintEventHandler(paint_States);
			this.pictureBox1.MouseDown += new MouseEventHandler(down_Picture);			
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.panel1 = new System.Windows.Forms.Panel();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.Location = new System.Drawing.Point(216, 16);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(280, 256);
			this.panel1.TabIndex = 0;
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(8, 16);
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(72, 20);
			this.textBox1.TabIndex = 1;
			this.textBox1.Text = "";
			// 
			// textBox2
			// 
			this.textBox2.Location = new System.Drawing.Point(8, 48);
			this.textBox2.Name = "textBox2";
			this.textBox2.Size = new System.Drawing.Size(72, 20);
			this.textBox2.TabIndex = 2;
			this.textBox2.Text = "textBox2";
			// 
			// pictureBox1
			// 
			this.pictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			//this.pictureBox1.Image = ((System.Drawing.Bitmap)(resources.GetObject("pictureBox1.Image")));
			pictureBox1.Image= Bitmap.FromFile("C:\\southeast.gif");
			this.pictureBox1.Location = new System.Drawing.Point(24, 80);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(112, 144);
			this.pictureBox1.TabIndex = 3;
			this.pictureBox1.TabStop = false;						// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.ClientSize = new System.Drawing.Size(504, 301);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.pictureBox1,
																		  this.textBox2,
																		  this.textBox1,
																		  this.panel1});
			this.Name = "Form1";
			this.Text = "Test zaznaczania i obsugi zdarze odrysowywania";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}
		private void down_Picture( object sender, MouseEventArgs e)
		{
			if (rectNC.Contains(e.X,e.Y) )
			{ MessageBox.Show("Stolica: Raleigh"); }
			else if(rectSC.Contains(e.X,e.Y))
			{ MessageBox.Show("Stolica: Columbia");}
			else if(rectGA.Contains(e.X,e.Y))
			{ MessageBox.Show("Stolica: Atlanta");}
			else if(gp.IsVisible(e.X,e.Y))
			{MessageBox.Show("Stolica: Tallahassee");}			
		}
		private void paint_States(object sender, PaintEventArgs e)
		{
			Graphics g = e.Graphics;
			rectNC = new Rectangle(55,15,35,10);
			rectSC = new Rectangle(50,35,25,10);
			rectGA = new Rectangle(32,45,20,30);
			Point[] ptsFL= {new Point(25,80),new Point(60,80),
							  new Point(82,125), new Point(70,125),
			                  new Point(50,85), new Point(25,85)};

			g.DrawRectangle(Pens.Black,rectNC);
			g.DrawRectangle(Pens.Black,rectSC);
			g.DrawRectangle(Pens.Black,rectGA);
			gp = new GraphicsPath();
			gp.AddPolygon(ptsFL);
			g.DrawPath(Pens.Black,gp);
			base.OnPaint(e);
		}
		private void paint_Form( object sender, PaintEventArgs e)
		{			
			Graphics g = e.Graphics;
			int ct = Environment.TickCount;
			textBox1.Text = ct.ToString();
            for (int i = 0; i< this.panel1.Width;i+=20) 
			{
				for (int j=0; j< this.panel1.Height;j+=20)
				{
					Rectangle r= new Rectangle(i,j,20,20);
					if (r.IntersectsWith(e.ClipRectangle)) 
					{
						Brush b = new SolidBrush(Color.FromArgb((i*j)%255, (i+j)%255, ((i+j)*j)%255));
						g.FillRectangle(b,r);
						g.DrawRectangle(Pens.White,r);
					}
				}
				ct = Environment.TickCount;
				textBox2.Text= ct.ToString();					
		    }
		}
	}
}
