using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
namespace GDIredraw
{
	// Rysuje figury dwuwymiarowe.
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Panel panel1;
		private Button button1;
		// Zmienna wymagana przez modu projektowania.
		private System.ComponentModel.Container components = null;
		public Form1()
		{
			//
			// Wymagane do obsugi Windows Form Designer.
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		 
		private void InitializeComponent()
		{
		    // 
			// button1
			// 
			button1 = new Button();
			this.button1.Location = new System.Drawing.Point(16, 220);
			this.button1.Name = "button8";
			this.button1.Size = new System.Drawing.Size(80, 24);
			this.button1.TabIndex = 1;
			this.button1.Text = "Rysuj figury";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// panel1
			// 
			panel1 = new Panel();
			this.panel1.BackColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.panel1.Location = new System.Drawing.Point(10, 16);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(456, 192);	
			// 
			this.Height= 280;
			this.Width= 500;
			this.Controls.Add(panel1);
			this.Controls.Add(button1);
			this.Text="Rysowanie figur paskich";
		}
		 
		// Gwny punkt startowy tej aplikacji.
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}
		
		private void button1_Click(object sender, System.EventArgs e)
		{
			using (Graphics g = panel1.CreateGraphics())
			{
				Pen blkPen = new Pen(Brushes.Black);
				blkPen.Width = 2;
				g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
				int x=20;
				int y=20;
				Rectangle r = new Rectangle(new	Point(x,y),new Size(40,40));
				g.DrawEllipse(blkPen,r);
				g.FillEllipse(Brushes.Black,x,y+60,40,40);
				
				// (2) Rysuje elips.
				Rectangle r2 = new Rectangle(new Point(x+60,y),new Size(60,40));
				g.DrawEllipse(blkPen,r2);

				// (3) Rysuje wycinek koa.
				r = new Rectangle( new	Point(x+160,y),new Size(80,80));
				// Tworzy kt pocztkowy i kt uku.
				float startAngle =  0.0F;
				float sweepAngle = -60.0F;
				g.DrawPie(blkPen, r, startAngle, sweepAngle);
				g.FillPie(Brushes.Black,x+160,y+60,80,80,startAngle,sweepAngle);
				
				// (4) Rysuje prost
				Point p1 = new Point(20,80);
				Point p2 = new Point(100,120);				

				// (5) Rysuje wielokt.
				Point pt1 = new Point(180,  y);
				Point pt2 = new Point(202,  y+12);
				Point pt3 = new Point(202,  y+32);
				Point pt4 = new Point(180,  y+44);
				Point pt5 = new Point(158,  y+32);
				Point pt6 = new Point(158,  y+12);
				Point[] myPoints = {pt1, pt2, pt3, pt4,pt5,pt6};
				g.DrawPolygon(blkPen, myPoints);			
			 
				// (6) Rysuje prostokt.
				blkPen.Width=5;
				g.DrawRectangle(blkPen,x+260,y,50,40);
				// (7) Rysuje prostokt z zaokrglonymi naronikami.
				blkPen.LineJoin = LineJoin.Bevel;
				g.DrawRectangle(blkPen,x+260,y+60,50,40);
				blkPen.Width=2;
				// (8) Rysuje wypenion elips.
				SolidBrush redBrush = new SolidBrush(Color.Red);
				// Tworzy prostokt dla elipsy.
				int width = 60;
				int height = 40;
				Rectangle rect = new Rectangle( x+60, y+60, width, height);
				g.FillEllipse(redBrush, rect);
				//
				g.TranslateTransform(0.0F, 60.0F);
				// Przeksztaca punkty reprezentowane w tabelicy na wsprzdne naronikw wielokta.
				g.TransformPoints(CoordinateSpace.Page,	CoordinateSpace.World,myPoints);
				// Zeruje transformacj.
				g.ResetTransform();
				g.FillPolygon(Brushes.Black, myPoints);
				// (10) Rysuje uk.
				startAngle=45F;
				sweepAngle=180F;
				g.DrawArc(blkPen, x+330, y, 40, 40, startAngle, sweepAngle);
				g.FillPie(Brushes.Black, x+330,y+60,40,40,startAngle,sweepAngle);
			}
		}		
	}
}
