using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Text;
namespace listview
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ListView listView1;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		
		private string imgPath= "\\obrazy\\";
		private System.ComponentModel.Container components = null;
		public Form1()
		{
			InitializeComponent();
			CreateMyListView();
			listView1.SelectedIndexChanged += new EventHandler(lv_IndexChanged);
			// Sortuje w odpowiedzi na kliknicie kolumny.
			this.listView1.ColumnClick += new ColumnClickEventHandler(ColumnClick);
		}
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.button2 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(262, 248);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(66, 24);
			this.button1.TabIndex = 0;
			this.button1.Text = "Due ikony";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(16, 208);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(216, 56);
			this.textBox1.TabIndex = 1;
			this.textBox1.Text = " ";
			// 
			// button2
			// 
			this.button2.Location = new System.Drawing.Point(262, 216);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(66, 24);
			this.button2.TabIndex = 2;
			this.button2.Text = "Mae ikony";
			this.button2.Click += new System.EventHandler(this.button2_Click);
            // 
			// button3
			// 
			this.button3.Location = new System.Drawing.Point(262, 184);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(66, 24);
			this.button3.TabIndex = 3;
			this.button3.Text = "Szczegy";
			this.button3.Click += new System.EventHandler(this.button3_Click);


			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(344, 273);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button2,
																		  this.textBox1,
																		  this.button3,
																		  this.button1});
			this.Name = "Form1";
			this.Text = "Artyci";
			//this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);
		}
		#endregion

		// Gwny punkt startowy tej aplikacji.
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		void CreateMyListView()
		{
			// (1) Tworzy now kontrolk typu ListView.
			listView1 = new ListView();		
			listView1.Bounds = new Rectangle(new Point(10,10), new Size(300, 170));
			listView1.Name = "listView1";
			// Ustawia tryb wywietlania szczegw.
			 listView1.View = View.Details;
			// Umoliwia uytkownikowi edycj tekstu elementw.
			listView1.LabelEdit = true;
			// Umoliwia uytkownikowi zmian ukadu kolumn.
			listView1.AllowColumnReorder = true;
			// Zaznacza element i podelementy w odpowiedzi na dokonany wybr.
			listView1.FullRowSelect = true;
			// Wywietla linie siatki.
			listView1.GridLines = true;
			// Sortuje elementy listy w porzdku rosncym.
			listView1.Sorting = SortOrder.Ascending;
                
			// (2) Tworzy pi elementw i trzy zbiory podelementw dla kadego z tych elementw.
			ListViewItem item1 = new ListViewItem("Manet",2);
			item1.SubItems.Add("1832");
			item1.SubItems.Add("1883");
			item1.SubItems.Add("Francja");
			// Alternatywny sposb dodawania elementw.
			ListViewItem item2 = new ListViewItem(new string[] {"Monet","1840","1926","France"}, 3);
			ListViewItem item3 = new ListViewItem("Rembrandt",4);
			item3.SubItems.Add("1606");
			item3.SubItems.Add("1669");
			item3.SubItems.Add("Holandia");
			ListViewItem item4 = new ListViewItem("Cezanne",1);
			item4.SubItems.Add("1839");
			item4.SubItems.Add("1906");
			item4.SubItems.Add("Francja");
			ListViewItem item5 = new ListViewItem("Botticelli",0);
			item5.SubItems.Add("1445");
			item5.SubItems.Add("1510");
			item5.SubItems.Add("Wochy");
			// Tworzy kolumny dla elementw i podelementw.
			listView1.Columns.Add("Artysta", -2, HorizontalAlignment.Left);
			listView1.Columns.Add("Urodzony", -2, HorizontalAlignment.Left);
			listView1.Columns.Add("Zmary", -2, HorizontalAlignment.Left);
			listView1.Columns.Add("Kraj", -2, HorizontalAlignment.Left);
			// Dodaje elementy do kontrolki typu ListView.
			listView1.Items.AddRange(new ListViewItem[]{item1,item2,item3,item4,item5});

			// (3) Tworzy dwa obiekty klasy ImageList.
			ImageList imageListSmall = new ImageList();
			ImageList imageListLarge = new ImageList();
			imageListLarge.ImageSize = new Size(30,30);

			// (4) Inicjalizuje nowoutworzone obiekty klasy ImageList z odpowiednimi bitmapami.
			imageListSmall.Images.Add(Bitmap.FromFile(imgPath+"botti.jpg"));
			imageListSmall.Images.Add(Bitmap.FromFile(imgPath+"cezanne.jpg"));
			imageListSmall.Images.Add(Bitmap.FromFile(imgPath+"manet.jpg"));
			imageListSmall.Images.Add(Bitmap.FromFile(imgPath+"monet.jpg"));
			imageListSmall.Images.Add(Bitmap.FromFile(imgPath+"rembrandt.jpg"));

			imageListLarge.Images.Add(Bitmap.FromFile(imgPath+"botti.jpg"));
			imageListLarge.Images.Add(Bitmap.FromFile(imgPath+"cezanne.jpg"));
			imageListLarge.Images.Add(Bitmap.FromFile(imgPath+"manet.jpg"));
			imageListLarge.Images.Add(Bitmap.FromFile(imgPath+"monet.jpg"));
			imageListLarge.Images.Add(Bitmap.FromFile(imgPath+"rembrandt.jpg"));

			// (5) Przypisuje obiekty klasy ImageList do kontrolki ListView.
			listView1.LargeImageList = imageListLarge;
			listView1.SmallImageList = imageListSmall;

			// Dodaje kontrolk ListView do kolekcji kontrolek.
			this.Controls.Add(listView1);
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
		    // Wywietla w formie duych ikon.
			ListView lv = listView1;
			lv.View = View.LargeIcon;
		}
		
		// Metoda obsugujca zdarzenie ColumnClick.
		private void ColumnClick(object o, ColumnClickEventArgs e)
		{
			this.listView1.ListViewItemSorter = new ListViewItemComparer(e.Column);
		}

		// Implementuje rczne sortowanie elementw wedug kolumn.
		class ListViewItemComparer : IComparer
		{
			private int col;
			public ListViewItemComparer()
			{
				col = 0;
			}
			public ListViewItemComparer(int column)
			{
				col = column;
			}
			public int Compare(object x, object y)
			{
				return String.Compare(((ListViewItem)x).SubItems[col].Text, ((ListViewItem)y).SubItems[col].Text);
			}
		}


		private void lv_IndexChanged(object sender, System.EventArgs e)
		{
			// Wywietla nazwisko w polu tekstowym w odpowiedzi na wybr nowego artysty.
			string ItemText = listView1.FocusedItem.Text;
			textBox1.Text= ItemText;
		}
		
		private void button2_Click(object sender, System.EventArgs e)
		{
		    // Wywietla mae ikony.
		    ListView lv = listView1;
			lv.View = View.SmallIcon;		 
		}
		private void button3_Click(object sender, System.EventArgs e)
		{
			// Wywietla szczegy.
			ListView lv = listView1;
			lv.View = View.Details;		 
		}
 
	}
}
