using System;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Collections;
using System.Text;
// 
//  Poniszy kod implementuje klas Chair i demonstruje sposb przykrywania
//  metod klasy System.Object.
//
class Serial
{
	public static void TestSerialize()
	{
		// Testuje serializacj.
		Hashtable ht = new Hashtable();
		Chair ch = new Chair(100.00D, "Broyhill", "10-009");
		ch.myUpholstery = new Upholstery("Bawena");
		ht.Add("Bawena", ch);
		// Dodaje drugi element do tablicy.
		ch = new Chair(200.00D, "Lane", "10-99");
		ch.myUpholstery = new Upholstery("Jedwab");
		ht.Add("Jedwab", ch);
		ch = new Chair(350.00D, "Henkel Harris", "09-08");
		ch.myUpholstery = new Upholstery("Jedwab");
		ht.Add("Jedwab2",ch);
		// Serializacja
		// Tworzy nowy plik; jeli plik ju istnieje, jego zawarto jest nadpisywana.
		FileStream fs= new  FileStream("\\chairs.dat",FileMode.Create); 
		BinaryFormatter bf= new BinaryFormatter();
		bf.Serialize(fs,ht);
		fs.Close();
		// Deserializuje plik binarny do postaci kolekcji Hashtable zawierajcej obiekty.
		ht.Clear();
		fs = new FileStream("\\chairs.dat", FileMode.Open);
		ht =  (Hashtable) bf.Deserialize(fs);
		ch = (Chair)ht["Jedwab"];
		Console.WriteLine("Deserializowane wartoci:");
		Console.WriteLine(ch.myUpholstery.Fabric);
		Console.WriteLine(ch.MyVen);
		fs.Close();                               
	}
 

	public static void TestSorting()
	{
		Chair[]chairsOrdered = new Chair[4];
		chairsOrdered[0] = new Chair(150.0, "Lane","99-88");
		chairsOrdered[1] = new Chair(250.0, "Lane","99-00");
		chairsOrdered[2] = new Chair(100.0, "Lane","98-88");
		chairsOrdered[3] = new Chair(120.0, "Harris","93-9");
		Array.Sort(chairsOrdered);
		// Wywietla list produktw posortowanych w porzdku rosncym wedug ceny.
		foreach(Chair c in chairsOrdered) 
			Console.WriteLine(c.ToString());
	}
	
	public static void TestHashTable()
	{
		// Tworzy obiekt klasy Hashtable.
		Hashtable chairHash = new Hashtable();
		// Dodaje do nowej tablicy skrtw dwie pary klucz-warto.
		chairHash.Add ("88-00", new Chair(350.0, "Adams", "88-00"));
		chairHash.Add ("99-03", new Chair(380.0, "Lane", "99-03"));
		// Rwnie dobrze moglibymy uy alternatywnej skadni:
		chairHash["89-01"] = new Chair(250.0, "Broyhill", "89-01");

		// (1) Sprawdza, czy kolekcja zawiera dany klucz.
		bool keyFound;
		if (chairHash.ContainsKey("88-00"))
			{ keyFound = true;} 
		else 
			{keyFound = false;}
		Console.WriteLine("{0} 88-00 in table",keyFound);

		// (2) Wywietla list kluczy.
		Console.WriteLine("Hash Keys");
		foreach (string invenKey in chairHash.Keys)
		{ Console.WriteLine(invenKey); }
		// (3) Wywietla list wartoci.
		foreach ( DictionaryEntry deChair in chairHash)  
		{
			Chair obj = (Chair) deChair.Value;
			Console.WriteLine(deChair.Key+" "+ obj.MyVen);
		}
    
	}
}

// Punkt wejcia do aplikacji
class App
{     
	static void Main(string[] args)
	{  
		Serial.TestSerialize();
		Console.WriteLine("Sortuje wedug ceny");
		Serial.TestSorting();	
		Serial.TestHashTable();
		Console.In.Read();
	}
}


[Serializable]
public class Chair: IComparable , ICloneable
{
	private double myPrice;
	private string myVendor, myID;
	private string finish;
	public Upholstery myUpholstery;
	// Konstruktor
	public Chair(double price, string vendor, string sku)
	{
		myPrice = price;
		myVendor = vendor;
		myID = sku;
	}

	// Przykryta metoda Equals().
	public override bool Equals(Object obj)
	{
		// Ponisza para instrukcji jest niezbdna, jeli dana klasa
		// dziedziczy po klasie, ktra sama przykrywa metod Equals().
		// if (!base.Equals(obj))
		//     return false;
		// (1) Obiekty puste (null) nie mog by porwnywane.
		if (obj == null) return false;
		// (2) Weryfikacja typw obiektw.
		if (this.GetType() != obj.GetType()) return false;
		// (3) Rzutowanie obiektu umoliwi nam uzyskiwanie dostpu do jego pl.
		Chair otherObj = (Chair) obj;
		// (4) Porwnanie zawartoci pl referencyjnych.
		if (!Object.Equals(myUpholstery, otherObj.myUpholstery)) return false;
		// (5) Porwnanie zawartoci skadowych wartociowych.
		if (!myVendor.Equals(otherObj.myVendor)) return false;
		if (!myPrice.Equals(otherObj.myPrice))   return false;
		if (!myID.Equals(otherObj.myID))         return false;        
		return true;
	}
	// Przykryta metoda GetHashCode()  ten krok jest wymagany tylko wtedy, gdy przykryto metod Equals().
	public override int GetHashCode()
	{
		return myID.GetHashCode();	 
	}

	// Przykryta metoda ToString().
	public override string ToString()
	{
		StringBuilder chairSB = new StringBuilder();
		chairSB.AppendFormat("TOWAR = Krzeso");
		chairSB.AppendFormat(" PRODUCENT = {0}", this.myVendor);
		chairSB.AppendFormat(" CENA = {0}", this.myPrice.ToString());
		return chairSB.ToString();
	}

	// Przykryta metoda Clone().
	public Object Clone()
	{
		return MemberwiseClone(); // from System.Object
	}	

	// Przykryta metoda CompareTo().
	int IComparable.CompareTo(Object obj)
	{
		if (obj is Chair) 
		{
			Chair castObj = (Chair)obj;
			if (this.myPrice > castObj.myPrice)
				return 1;
			if (this.myPrice < castObj.myPrice)
				return -1;
			else return 0;
			// Aby sortowa w porzdku malejcym, zamie wartoci 1 i 1.
		}
		throw new ArgumentException("Przekazany obiekt nie jest instancj klasy Chair");
	}

	public string MyVen
	{
		set { myVendor = value; }
		get { return myVendor; }
	}
	public double MyPr
	{
		get { return myPrice; }
	}
}
[Serializable]
public class Upholstery
{
	public string Fabric ;
	public Upholstery( string fab)
	{ Fabric = fab; }
}