﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mail;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Synchronization
{
    class Example14
    {
        // Listing 17-14
        static void LogFailure(string message, string mailServer)
        {
            var email = new SmtpClient(mailServer);

            using (var emailSent = new ManualResetEvent(false))
            {
                bool tooLate = false; // Uniemożliwiamy wywoływanie metody Set po upłynięciu 
                                      // limitu czasu
                email.SendCompleted += (s, e) => { if (!tooLate) { emailSent.Set(); } };
                email.SendAsync("logger@example.com", "sysadmin@example.com",
                    "Zgłoszenie awarii", "Wystąpił błąd: " + message, null);

                LogPersistently(message);

                if (!emailSent.WaitOne(TimeSpan.FromMinutes(1)))
                {
                    LogPersistently("Upłynął limit czasu wysyłania wiadomości: " + message);
                }
                tooLate = true;
            }
        }

        private static void LogPersistently(string message)
        {
            // W prawdziwej aplikacji ta metoda zapisywałaby coś w dzienniku.
        }
    }
}
