﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace CustomAttributes
{
    class Example19
    {
        // Listing 15-19 (jednak "*.dll" zmieniono na "*.exe", aby można było zobaczyć jakieś efekty)
        static void ShowPluginInformation(string pluginFolder)
        {
            var dir = new DirectoryInfo(pluginFolder);
            foreach (var file in dir.GetFiles("*.exe"))
            {
                Assembly pluginAssembly = Assembly.LoadFrom(file.FullName);
                var plugins =
                     from type in pluginAssembly.GetTypes()
                     let info = type.GetCustomAttribute<PluginInformationAttribute>()
                     where info != null
                     select new { type, info };

                foreach (var plugin in plugins)
                {
                    Console.WriteLine("Typ wtyczki: {0}", plugin.type.Name);
                    Console.WriteLine("Nazwa: {0}, autor {1}",
                                      plugin.info.Name, plugin.info.Author);
                    Console.WriteLine("Opis: {0}", plugin.info.Description);
                }
            }
        }

        public static void FindAttributes()
        {
            ShowPluginInformation(Path.GetDirectoryName(typeof(Example19).Assembly.Location));
        }
    }
}
