﻿using System;
using System.Net;
using System.Reactive.Linq;
using System.Reactive.Threading.Tasks;
using System.Threading.Tasks;

namespace Adaptation
{
    class Example42
    {
        // Listing 11-42
        public static IObservable<string> GetWebPageAsObservable(Uri pageUrl)
        {
            return Observable.FromAsync(() =>
            {
                var web = new WebClient();
                return web.DownloadStringTaskAsync(pageUrl);
            });
        }

        public static void UseAsyncWrapper()
        {
            Console.WriteLine("Pobieramy stronę");
            string pageContent = GetWebPageAsObservable(new Uri("http://www.interact-sw.co.uk/iangblog/")).SingleAsync().Wait();
            Console.WriteLine("Wielkość strony: " + pageContent.Length);
        }
    }
}
