﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RaisingExceptions
{
    class Examples8_10
    {
        // Listing 8-8
        public static int CountCommas(string text)
        {
            if (text == null)
            {
                throw new ArgumentNullException("text");
            }
            return text.Count(ch => ch == ',');
        }

        public static void CatchThrownException()
        {
            try
            {
                CountCommas(null);
            }
            catch (Exception x)
            {
                Console.WriteLine(x);
            }
        }

        public static void LossOfContext()
        {
            try
            {
                // Listing 8-9
                try
                {
                    DoSomething();
                }
                catch (IOException x)
                {
                    LogIOError(x);
                    // Kolejny wiersz kodu jest NIEPRAWIDŁOWY!
                    throw x;  // Tak nie należy powtórnie zgłaszać wyjątku
                }
            }
            catch (Exception x)
            {
                // Ta instrukcja zgłosi wyjątek, tak jak gdyby pojawiał się on
                // w miejscu w którym został ponownie zgłoszony, a nie w faktycznym
                // miejscu wystąpienia.
                Console.WriteLine(x);
            }
        }

        public static void PreservingContext()
        {
            try
            {
                // Listing 8-10
                try
                {
                    DoSomething();
                }
                catch (IOException x)
                {
                    LogIOError(x);
                    throw;
                }

            }
            catch (Exception x)
            {
                // Ta instrukcja zgłosi wyjątek, tak jak gdyby pojawiał się on
                // w miejscu w którym został ponownie zgłoszony, a nie w faktycznym
                // miejscu wystąpienia.
                Console.WriteLine(x);
            }
        }

        private static void LogIOError(IOException x)
        {
            Console.WriteLine("Błąd wejścia-wyjścia: " + x.Message);
        }

        private static void DoSomething()
        {
            // To jest faktyczne miejsce, w którym powstaje wyjątek, dlatego
            // chcielibyśmy by informacje o nim pojawiały się na stosie wyjątku,
            // jednak po ponownym zgłoszeniu nie będą się one dostępne.
            throw new IOException("Symulowany błąd");
        }
    }
}
