﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Delegates
{
    class Examples1_5
    {
        // Listing 9-1
        public static int GetIndexOfFirstNonEmptyBin(int[] bins)
        {
            return Array.FindIndex(bins, IsGreaterThanZero);
        }

        private static bool IsGreaterThanZero(int value)
        {
            return value > 0;
        }


        // Listing 9-2
        // (W tekście książki ten przykład ma jedynie pokazywać jak wygląda sygnatura 
        // metody Array.FindIndex. Dlateg też tutaj jedynie wywołujemy tę metodę.)
        public static int FindIndex<T>(
            T[] array,
            Predicate<T> match
            )
        {
            return Array.FindIndex(array, match);
        }

        // Kod umieszczony w komentarzu gdyż pokazuje jak wygląda definicja typu w CLR.
        // Listing 9-3
        //public delegate bool Predicate<in T>(T obj);


        public static void ExplicitConstruction()
        {
            // Listing 9-4
            var p = new Predicate<int>(IsGreaterThanZero);
        }

        public static void ImplicitConstruction()
        {
            // Listing 9-5
            Predicate<int> p = IsGreaterThanZero;
        }
    }
}
