﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Lifetime
{
    // Listing 7-14
    public sealed class Logger : IDisposable
    {
        private StreamWriter _file;

        public Logger(string filePath)
        {
            _file = File.CreateText(filePath);
        }

        public void Dispose()
        {
            if (_file != null)
            {
                _file.Dispose();
                _file = null;
            }
        }
        // Oczywiście rzeczywista klasa używałaby obiektu StreamWriter do 
        // wykonania jakichś działań.
    }



    // Listing 7-15
    public class MyFunkyStream : Stream
    {
        // Tak klasa służy wyłącznie do celów demonstracyjnych. 
        // Zazwyczaj lepszym rozwiązaniem będzie użycie jednego 
        // z typów pochodnych klasy SafeHandle.
        private IntPtr _myCustomLibraryHandle;
        private Logger _log;

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);

            if (_myCustomLibraryHandle != IntPtr.Zero)
            {
                MyCustomLibraryInteropWrapper.Close(_myCustomLibraryHandle);
                _myCustomLibraryHandle = IntPtr.Zero;
            }
            if (disposing)
            {
                if (_log != null)
                {
                    _log.Dispose();
                    _log = null;
                }
            }
        }

        public override bool CanRead
        {
            get { throw new NotImplementedException(); }
        }

        public override bool CanSeek
        {
            get { throw new NotImplementedException(); }
        }

        public override bool CanWrite
        {
            get { throw new NotImplementedException(); }
        }

        public override void Flush()
        {
            throw new NotImplementedException();
        }

        public override long Length
        {
            get { throw new NotImplementedException(); }
        }

        public override long Position
        {
            get
            {
                throw new NotImplementedException();
            }
            set
            {
                throw new NotImplementedException();
            }
        }

        public override int Read(byte[] buffer, int offset, int count)
        {
            throw new NotImplementedException();
        }

        public override long Seek(long offset, SeekOrigin origin)
        {
            throw new NotImplementedException();
        }

        public override void SetLength(long value)
        {
            throw new NotImplementedException();
        }

        public override void Write(byte[] buffer, int offset, int count)
        {
            throw new NotImplementedException();
        }
    }


    class MyCustomLibraryInteropWrapper
    {
        internal static void Close(IntPtr _myCustomLibraryHandle)
        {
            // W rzeczywistym przykładzie, to byłaby jakaś metoda korzystająca 
            // z mechanizmów współdziałania.
        }
    }
}
