﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;

namespace UsingAsync
{
    class Examples9_11
    {
        // Listing 18-9
        public static async Task<string> GetServerHeader(string url)
        {
            using (var w = new HttpClient())
            {
                var request = new HttpRequestMessage(HttpMethod.Head, url);
                HttpResponseMessage response =
                    await w.SendAsync(request, HttpCompletionOption.ResponseHeadersRead);

                string result = null;
                IEnumerable<string> values;
                if (response.Headers.TryGetValues("Server", out values))
                {
                    result = values.FirstOrDefault();
                }
                return result;
            }
        }

        public static void AsyncLambda()
        {
            var okButton = new Button();
            var infoTextBlock = new TextBlock();
            var uriTextBox = new TextBox();

            // Listing 18-10
            okButton.Click += async (s, e) =>
            {
                using (var w = new HttpClient())
                {
                    infoTextBlock.Text = await w.GetStringAsync(uriTextBox.Text);
                }
            };

            // Listing 18-11
            okButton.Click += async delegate(object s, RoutedEventArgs e)
            {
                using (var w = new HttpClient())
                {
                    infoTextBlock.Text = await w.GetStringAsync(uriTextBox.Text);
                }
            };

        }
    }
}
    