﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CustomAttributes
{
    // Listing 15-15
    [AttributeUsage(AttributeTargets.Class)]
    public class PluginInformationAttribute : Attribute
    {
        public PluginInformationAttribute(string name, string author)
        {
            Name = name;
            Author = author;
        }

        public string Name { get; private set; }

        public string Author { get; private set; }

        public string Description { get; set; }
    }

    // Listing 15-16
    [PluginInformation("Raportowanie", "Interact Software Ltd.")]
    public class ReportingPlugin
    {
    }

    // Kolejny przykład został umieszczony w klasie, by zapobiec konfliktom nazw.
    class Nest
    {
        // Listing 15-17
        [PluginInformation("Raportowanie", "Interact Software Ltd.",
            Description = "Automatyczna generacja raportów")]
        public class ReportingPlugin
        {
        }
    }
}
