﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DynamicDetails
{
    class Examples19_26
    {
        // Listing 14-19
        static void UseInt(int x)
        {
            Console.WriteLine(x);
        }


        public static void UsingDelegate()
        {
            // Listing 14-20
            Action<int> a = UseInt;
            dynamic da = a;
            da(42);

            // Kod umieszczony w komentarzach gdyż ilustruje coś czego nie można zrobić.
            // Listing 14-21
            //dynamic da = UseInt;  // Tego nie uda się skompilować
        }

        // Listing 14-22
        public delegate void IntHandler(int x);

        public static void PlausibleButNonWorkingExample()
        {
            // Ten kod można skompilować, ale zgłosi wyjątek po uruchomieniu
            try
            {
                // Listing 14-23
                Action<int> a = UseInt;
                dynamic da = a;

                IntHandler ih = da;
                ih(42);
            }
            catch (Exception x)
            {
                Console.WriteLine(x);
            }
        }

        // Listing 14-24
        static void UseAnything(dynamic x)
        {
            Console.WriteLine(x);
        }

        public static void NonAvailabilityOfExtensionMethods()
        {
            // Działa dobrze.
            {
                // Listing 14-25
                IEnumerable<int> xs = Enumerable.Range(1, 20);
                IEnumerable<int> evens = xs.Where(x => x % 2 == 0);
            }

            // Jeśli zmienimy typ xs na dynamic, to kodu nie będzie można skompilować.
            {
                dynamic xs = Enumerable.Range(1, 20);
                //IEnumerable<int> evens = xs.Where(x => x % 2 == 0);
            }

            // Można sprawić, że kod się skompiluje, ale i tak zgłosi wyjątek w trakcie działania prgoramu.
            try
            {
                // Listing 14-26
                dynamic xs = Enumerable.Range(1, 20);
                Func<int, bool> pred = x => x % 2 == 0;
                IEnumerable<int> evens = xs.Where(pred);
            }
            catch (Exception x)
            {
                Console.WriteLine(x);
            }
        }
    }
}
