﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Reflection.Context;
using System.Text;
using System.Threading.Tasks;

namespace Examples5_13
{
    class NotVeryInteresting
    {
    }

    class MyReflectionContext : CustomReflectionContext
    {
        protected override IEnumerable<PropertyInfo> AddProperties(Type type)
        {
            if (type == typeof(NotVeryInteresting))
            {
                var fakeProp = CreateProperty(
                    MapType(typeof(string).GetTypeInfo()),
                    "FakeProperty",
                    o => "FikcyjnaWartość",
                    (o, v) => Console.WriteLine("Określenie wartości: " + v));

                return new[] { fakeProp };
            }
            else
            {
                return base.AddProperties(type);
            }
        }
    }

    class Examples12_13
    {
        public static void UseCustomReflectionContext()
        {
            var ctx = new MyReflectionContext();
            Type mappedType = ctx.MapType(typeof(NotVeryInteresting).GetTypeInfo());

            foreach (PropertyInfo prop in mappedType.GetProperties())
            {
                Console.WriteLine("{0} ({1})", prop.Name, prop.PropertyType.Name);
            }
        }
    }
}
