﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Contexts
{
    // Listing 17-9
    public class Defer
    {
        private readonly Action _callback;
        private readonly ExecutionContext _context;

        public Defer(Action callback)
        {
            _callback = callback;
            _context = ExecutionContext.Capture();
        }

        public void Run()
        {
            ExecutionContext.Run(_context, (unusedStateArg) => _callback(), null);
        }
    }

}
