﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace ThreadPoolExamples
{
    class Example6
    {
        // Listing 17-6
        private static void DoWork()
        {
            Task.Factory.StartNew(() => Download("http://oreilly.com/"));
        }

        private static Random r = new Random(0);

        private static void Download(string url)
        {
            using (var w = new WebClient())
            {
                Console.WriteLine("Pobieranie strony " + url);
                string page = w.DownloadString(url);
                Console.WriteLine("Pobrano stronę {0}, długość {1}", url, page.Length);
            }
        }

        internal static void StartWithLambda()
        {
            DoWork();
        }
    }
}
