﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Streams
{
    class Example2
    {
        // Listing 16-2
        static int ReadAll(Stream s, byte[] buffer, int offset, int length)
        {
            if ((offset + length) > buffer.Length)
            {
                throw new ArgumentException("Bufor jest zbyt mały, by pomieścić żadane dane.");
            }

            int bytesReadSoFar = 0;
            while (bytesReadSoFar < length)
            {
                int bytes = s.Read(
                    buffer, offset + bytesReadSoFar, length - bytesReadSoFar);
                if (bytes == 0)
                {
                    break;
                }
                bytesReadSoFar += bytes;
            }

            return bytesReadSoFar;
        }
    }
}
