﻿// Listing 16-4
using System;
using System.IO;

namespace ConsoleApplication1
{
    class Program
    {
        const long gig = 1024 * 1024 * 1024;

        const int DiskFullErrorCode = unchecked((int) 0x80070070);
        const int HandleDiskFullErrorCode = unchecked((int) 0x80070027);

        static void Main(string[] args)
        {
            try
            {
                using (var fs = File.OpenWrite(@"c:\temp\long.txt"))
                {
                    fs.SetLength(10000 * gig);
                }
            }
            catch (IOException x)
            {
                if (x.HResult == DiskFullErrorCode ||
                    x.HResult == HandleDiskFullErrorCode)
                {
                    Console.WriteLine("Brak miejsca na dysku.");
                }
                else
                {
                    Console.WriteLine(x);
                }
            }
        }
    }
}
