using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace Exercise1
{
	// Klasa przechowujce wywietlane informacje
	public class CountDownClockEventArgs : EventArgs
	{
		public readonly string message;
		public CountDownClockEventArgs(string message)
		{
			this.message = message;
		}
	}

	// Podmiot (wydawca). Klasa, do ktrej inne klasy
	// zgaszaj subskrypcje. Udostpnia delegata TimeExpired
	// wyzwalanego po upywie okrelonego czasu
	public class CountDownClock
	{
		private DateTime startingTime;
		private DateTime targetTime;
		private string message;

		// Podaje komunikat przeznaczony do wywietlenia i ile czasu
		// (godziny, minuty, sekundy) naley czeka
		public CountDownClock(string message, int hours, int mins, int seconds)
		{
			this.message = message;
			startingTime = DateTime.Now;
			TimeSpan duration = new TimeSpan(hours, mins, seconds);
			targetTime = startingTime + duration;
		}

		// Delegat
		public delegate void TimesUpEventHandler
		(
		   object countDownClock,
		   CountDownClockEventArgs alarmInformation
		);

		// Egzemplarz delegata
		public TimesUpEventHandler TimeExpired;

		// 10 razy na sekund sprawdza, czy czas ju upyn.
		// Jeli tak, a s obiekty nasuchujce, naley przekaza komunikat
		public void Run()
		{
			for (; ; )
			{
				// Upienie na 1/10 sekundy
				Thread.Sleep(100); // Milisekundy

				// Pobiera biecy czas
				System.DateTime rightNow = System.DateTime.Now;

				if (rightNow >= this.targetTime)
				{
					if (TimeExpired != null)
					{
						// Tworzy obiekt CountDownClockEventArgs przechowujcy komunikat
						CountDownClockEventArgs e =
						   new CountDownClockEventArgs(this.message);
						// Zgoszenie zdarzenia
						TimeExpired(this, e);
						// Zatrzymuje zegar
						break;
					} // Koniec jeli s zarejestrowane delegaty
				}    // Koniec jeli czas upyn
			}       // Koniec nieskoczonej ptli
		}          // Koniec Run
	}             // Koniec klasy

	// Obserwator
	public class CountDownTimerDisplay
	{
		CountDownClock.TimesUpEventHandler myHandler;

		public CountDownTimerDisplay(CountDownClock cdc)
		{
			myHandler = new CountDownClock.TimesUpEventHandler(TimeExpired);

			// Rejestruje metod obsugi zdarzenia i uruchamia zegar
			cdc.TimeExpired += myHandler;
		}

		// Informuje uytkownika, e czas upyn
		public void TimeExpired(object theClock, CountDownClockEventArgs e)
		{
			Console.WriteLine(e.message);
		}
	}

	// Obserwator
	public class CountDownTimerLog
	{
		CountDownClock.TimesUpEventHandler myHandler;

		public CountDownTimerLog(CountDownClock cdc)
		{
			myHandler = new CountDownClock.TimesUpEventHandler(TimeExpired);

			// Rejestruje metod obsugi zdarzenia i uruchamia zegar
			cdc.TimeExpired = myHandler;
		}

		// Informuje uytkownika, e czas upyn
		public void TimeExpired(object theClock, CountDownClockEventArgs e)
		{
			Console.WriteLine("logowanie " + e.message);
		}
	}

	public class Test
	{
		public static void Main()
		{
			Console.Write("Podaj komunikat: ");
			string message = Console.ReadLine();

			// Uwaga: oczywicie naley utworzy bardziej zoony interfejs
			// pozwalajcy ustawi uytkownikowi odpowiedni ilo czasu. Tu
			// program po prostu prosi uytkownika o podanie liczby sekund
			Console.Write("Ile sekund?: ");
			int seconds = Convert.ToInt32(Console.ReadLine());

			CountDownClock cdc = new CountDownClock(message, 0, 0, seconds);
			CountDownTimerDisplay display = new CountDownTimerDisplay(cdc);
			CountDownTimerLog logger = new CountDownTimerLog(cdc);
			cdc.Run();

		}
	}
}

