using System;
using System.Collections.Generic;

namespace ConsoleApplication1
{
   
   class Cat
   {
      private int age;

      public int Age
      {
         get { return age; }
         set { age = value; }
      }
      public Cat( int age )
      {
         this.age = age;
      }
   }

   // Niestandardowa klasa wyjtku
   public class CustomCatException :
      System.ApplicationException
   {
      public CustomCatException(string message)
         :
      base(message) // Przekazywanie komunikatu do klasy bazowej
      {

      }
   }

   class Tester
   {
      private void CheckCat(Cat testCat)
      {
         if (testCat.Age <= 0)
         {
            // Tworzenie egzemplarza niestandardowego wyjtku
            CustomCatException e = 
               new CustomCatException("Podany kot nie istnieje");
            e.HelpLink = 
               "http://www.libertyassociates.com/NoZeroDivisor.htm";
            throw e;
         }
      }
   
      private void CatManager(Cat kitty)
      {
         CheckCat(kitty);
         Console.WriteLine ("Zarzdzam kotem, ktry ma " + kitty.Age + " lat");
      }

      public void Run()
      {
         try
         {
            Console.WriteLine(
               "Przydzia zasobw, ktre wymagaj zwolnienia");

            List<Cat> cats = new List<Cat>();
            cats.Add( new Cat( 7 ) );
            cats.Add( new Cat( -2 ) );

            CatManager( cats[0] ); // Przekazanie pierwszego kota
            CatManager( cats[1] ); // Przekazanie drugiego kota
 
            Console.WriteLine(
               "Program moe, ale nie musi wywietli tego wiersza");
         }

         // Przechwytywanie niestandardowego wyjtku
         catch (CustomCatException e)
         {
            Console.WriteLine(
               "\nCustomCatException! Komunikat: {0}",
               e.Message);
            Console.WriteLine(
               "\nHelpLink: {0}\n", e.HelpLink);
         }

         catch ( System.ArgumentOutOfRangeException )
         {
            Console.WriteLine(
               "Czsto widziaam kota bez umiechu, \nale nigdy jeszcze " +
               "nie spotkaam umiechu bez kota" );
         }

         catch (Exception e)
         {
            Console.WriteLine("Przechwycono nieznany wyjtek" + e.Message);
         }

         finally
         {
            Console.WriteLine("Tu zwalnianie zasobw.");
         }
      }

      static void Main()
      {
         Console.WriteLine( "Wejcie do metody Main..." );
         Tester t = new Tester();
         t.Run();
         Console.WriteLine( "Wyjcie z metody Main..." );

		 Console.ReadLine();
      }
   }
}
