using System;

abstract public class Animal
{
	protected int weight;
	protected string name;
	public Animal(int weight, string name)
	{
		this.weight = weight;
		this.name = name;
	}
	abstract public void Speak();
	abstract public void Move();
	public override string ToString()
	{
		throw new Exception("Brak implementacji danej metody lub operacji.");
	}
}

public class Dog : Animal
{
	private string breed;

	public string Breed
	{
		get { return breed; }
		set { breed = value; }
	}
	public Dog(int weight, string name, string breed)
		:
	   base(weight, name)
	{
		this.breed = breed;
	}

	public override void Speak()
	{ Console.WriteLine("Hau"); }

	public override void Move()
	{ Console.WriteLine("Biegnie, biegnie, biegnie, lini si."); }

	public override string ToString()
	{
		return "Wabi si " + this.name + ", wa " + this.weight +
		   " kilogramw i jestem rasy " + this.breed + "\n";
	}
}

public class Cat : Animal
{

	public Cat(int weight, string name)
		:
	   base(weight, name)
	{ }

	public override void Speak()
	{ Console.WriteLine("Miau"); }

	public override void Move()
	{ Console.WriteLine("Biegnie, skacze, drzemie."); }

	public override string ToString()
	{
		return "Wabi si " + this.name + ", wa " + this.weight +
		   " kilogramw i potrafi mrucze!\n";
	}

	public void Purr()
	{
		Console.WriteLine("Mrrrrrrrrrrrrrrrrrrrrrr\n");
	}

}

public class Tester
{
	static void Main()
	{
		Animal[] myAnimals = new Animal[5];
		myAnimals[0] = new Dog(36, "Milog", "Golden");
		myAnimals[1] = new Cat(6, "Szekspir");
		myAnimals[2] = new Cat(5, "Alegra");
		myAnimals[3] = new Dog(25, "Dingo", "kundel");
		myAnimals[4] = new Dog(10, "Brandy", "Beagle");

		foreach (Animal a in myAnimals)
		{
			a.Speak();
			a.Move();
			Console.WriteLine(a);

			Cat c = a as Cat; // Rzutowanie na klas Cat
			if (c != null)  // Jeli jest to kot
			{
				c.Purr();      // Tylko koty mrucz
			}
		}
	}

}

