using System;
public class Tester
{
	public abstract class Telephone
	{
		protected string phonetype;
		public abstract void Ring();   // Teraz abstrakcyjna
	}

	public class DigitalPhone : Telephone
	{
		public DigitalPhone()
		{
			this.phonetype = "Cyfrowy";   // Dostp do zmiennej chronionej
		}
		public override void Ring()   // Implementacja
		{
			Console.WriteLine("Dzwoni telefon {0}. Bip bip.", phonetype);
		}
	}

	public class TalkingPhone : Telephone
	{
		public TalkingPhone()
		{
			this.phonetype = "Mwicy";   // Dostp do zmiennej chronionej
		}
		public override void Ring()   // Implementacja
		{
			Console.WriteLine("Dzwoni telefon {0}. Odbierz telefon.",
							   phonetype);
		}
	}

	public void Run()
	{
		// Przypisuje egzemplarz klasy pochodnej do zmiennej typu klasy bazowej
		Telephone phone1 = new DigitalPhone();
		Telephone phone2 = new TalkingPhone();
		phone1.Ring();   // Dostp do metody polimorficznej
		phone2.Ring();   // Dostp do metody polimorficznej
	}

	static void Main()
	{
		Tester t = new Tester();
		t.Run();
	}
}
