using System;

public class Invoice
{
	private string vendor;
	private double amount;

	public string Vendor
	{
		get
		{
			return vendor;
		}
		set
		{
			vendor = value;
		}
	}

	public double Amount
	{
		get
		{
			return amount;
		}
		set
		{
			amount = value;
		}
	}

	// Konstruktor
	public Invoice(string vendor, double amount)
	{
		this.vendor = vendor;
		this.amount = amount;
	}

	// Przeciony operator + przyjmuje dwie faktury (obiekty Invoice).
	// Jeli dostawcy (vendor) s tacy sami, wartoci faktur (amount) naley doda.
	// Jeli nie, operacje nie powiedzie si, a operator zwraca pust faktur.

	public static Invoice operator +(Invoice lhs, Invoice rhs)
	{
		if (lhs.vendor == rhs.vendor)
		{
			return new Invoice(lhs.vendor, lhs.amount + rhs.amount);
		}
		else
		{
			Console.WriteLine("Rni dostawcy. Operacja nieudana.");
			return new Invoice("", 0);
		}
	}

	// Przeciony operator rwnoci
	public static bool operator ==(Invoice lhs, Invoice rhs)
	{
		if (lhs.vendor == rhs.vendor && lhs.amount == rhs.amount)
		{
			return true;
		}
		return false;
	}

	// Przeciony operator nierwnoci. Deleguje operacj do operatora ==
	public static bool operator !=(Invoice lhs, Invoice rhs)
	{
		return !(lhs == rhs);
	}

	// Metoda okrelajca rwnoci. Sprawdza, czy obiekty maj ten sam typ,
	// a nastpnie deleguje operacj do operatora ==
	public override bool Equals(object o)
	{
		if (!(o is Invoice))
		{
			return false;
		}
		return this == (Invoice)o;
	}

	public void PrintInvoice()
	{
		Console.WriteLine("Faktura od {0} na kwot {1} zotych.", this.vendor,
						  this.amount);
	}
}

public class Tester
{
	public void Run()
	{
		Invoice firstInvoice = new Invoice("FirmaRodzinna", 399.65);
		Invoice secondInvoice = new Invoice("FirmaGigant", 56389.53);
		Invoice thirdInvoice = new Invoice("FirmaGigant", 399.65);

		Invoice testInvoice = new Invoice("FirmaGigant", 399.65);

		if (testInvoice == firstInvoice)
		{
			Console.WriteLine("Pierwsza faktura jest taka sama.");
		}
		else if (testInvoice == secondInvoice)
		{
			Console.WriteLine("Druga faktura jest taka sama.");
		}
		else if (testInvoice == thirdInvoice)
		{
			Console.WriteLine("Trzecia faktura jest taka sama.");
		}
		else
		{
			Console.WriteLine("adna faktura nie jest taka sama.");
		}

	}
	static void Main()
	{
		Tester t = new Tester();
		t.Run();
	}
}

