// Wsplne deklaracje uywane w plikach parser.cpp, minicpp.cpp, 
// libcpp.cpp i innych dodanych przez ciebie.
// 
const int MAX_T_LEN  = 128;   // maksymalna dugo tokena
const int MAX_ID_LEN = 31;    // maksymalna dugo identyfikatora
const int PROG_SIZE  = 10000; // maksymalny rozmiar programu
const int NUM_PARAMS = 31;    // maksymalna liczba parametrw
 
// Typ wyliczeniowy rodzaju tokenw.
enum tok_types { UNDEFTT, DELIMITER, IDENTIFIER, 
                 NUMBER, KEYWORD, TEMP, STRING, BLOCK }; 
 
// Typ wyliczeniowy wewntrznej reprezentacji tokenw. 
enum token_ireps { UNDEFTOK, ARG, CHAR, INT, SWITCH, 
                   CASE, IF, ELSE, FOR, DO, WHILE, BREAK, 
                   RETURN, COUT, CIN, END }; 
 
// Typ wyliczeniowy operatorw dwuznakowych takich jak <=.
enum double_ops { LT=1, LE, GT, GE, EQ, NE, LS, RS, INC, DEC }; 
 
// Stae uywane przy zgaszaniu
// wyjtku bdu skadniowego.
// 
// UWAGA: SYNTAX oznacza oglny komunikat bdu, gdy
// nic innego nie pasuje.
enum error_msg 
     { SYNTAX, NO_EXP, NOT_VAR, DUP_VAR, DUP_FUNC, 
       SEMI_EXPECTED, UNBAL_BRACES, FUNC_UNDEF, 
       TYPE_EXPECTED, RET_NOCALL, PAREN_EXPECTED, 
       WHILE_EXPECTED, QUOTE_EXPECTED, DIV_BY_ZERO, 
       BRACE_EXPECTED, COLON_EXPECTED }; 
 
extern char *prog;  // aktualne pooenie w kodzie rdowym
extern char *p_buf; // wskazuje na pocztek bufora programu
 
extern char token[MAX_T_LEN+1]; // token w postaci acucha znakowego
extern tok_types token_type; // zawiera typ tokenu
extern token_ireps tok; // wewntrzna reprezentacja tokenu
 
extern int ret_value; // zwracana przez funkcj warto
 
extern bool breakfound; // ma warto true jeli napotkano instrukcj break
 
// Klasa wyjtku dla interpretera Mini C++.
class InterpExc { 
  error_msg err; 
public: 
  InterpExc(error_msg e) { err = e; } 
  error_msg get_err() { return err; } 
}; 
 
// Deklaracje funkcji interpretera.
void prescan(); 
void decl_global(); 
void call(); 
void putback(); 
void decl_local(); 
void exec_if(); 
void find_eob(); 
void exec_for(); 
void exec_switch(); 
void get_params(); 
void get_args(); 
void exec_while(); 
void exec_do(); 
void exec_cout(); 
void exec_cin(); 
void assign_var(char *var_name, int value); 
bool load_program(char *p, char *fname); 
int find_var(char *s); 
void interp(); 
void func_ret(); 
char *find_func(char *name); 
bool is_var(char *s); 
token_ireps find_var_type(char *s); 
 
// Deklaracje funkcji parsera.
void eval_exp(int &value); 
void eval_exp0(int &value); 
void eval_exp1(int &value); 
void eval_exp2(int &value); 
void eval_exp3(int &value); 
void eval_exp4(int &value); 
void eval_exp5(int &value); 
void atom(int &value); 
void sntx_err(error_msg error); 
void putback(); 
bool isdelim(char c); 
token_ireps look_up(char *s); 
int find_var(char *s); 
tok_types get_token(); 
int internal_func(char *s); 
bool is_var(char *s); 
 
// Deklaracje funkcji z "biblioteki standardowej".
int call_getchar(); 
int call_putchar(); 
int call_abs(); 
int call_rand();

