#include <iostream> 
#include <cmath> 
#include <iomanip> 
#include <locale> 
 
using namespace std; 
 
// Obliczanie pocztkowej wartoci inwestycji
// wymagan do otrzymania okrelonych regularnych wypat
double annuity(double regWD, double rateOfRet, 
               int numYears, int numPerYear) {  
 
  double b, e;  
  double t1, t2;  
  
  rateOfRet /= 100.0; // przekszta procenty na uamki
 
  t1 = (regWD * numPerYear) / rateOfRet;  
  
  b = (1 + rateOfRet/numPerYear);  
  e = numPerYear * numYears;  
  
  t2 = 1 - (1 / pow(b, e));  
     
  return t1 * t2;  
} 
 
int main() { 
  double wd, r; 
  int y, wpy; 
 
cout.imbue(locale("polish")); 
 
  cout << "Wprowad podan kwot wypaty: "; 
  cin >> wd; 
 
  cout << "Wprowad wysoko oprocentowania lokaty (wyraon w procentach): "; 
  cin >> r; 
 
  cout << "Wprowad liczb lat: "; 
  cin >> y; 
 
  cout << "Wprowad liczb wypat w roku: "; 
  cin >> wpy; 
 
  cout << "\nWymagana pocztkowa wysoko lokaty: "  
       << fixed << setprecision(2) 
       << annuity(wd, r, y, wpy) << endl; 
 
  return 0; 
}
