// Translator eksperymentalnych elementw jzyka C++
#include <iostream>  
#include <fstream>  
#include <cctype>  
#include <cstring>  
#include <string>  
  
using namespace std;  
  
// Prototypu funkcji obsugujcych wprowadzane
// sowa kluczowe.
void foreach();  
void cases();  
void repeat();  
void until();  
void typeof();  
  
// Prototypy funkcji dzielcych kod na etony.  
bool gettoken(string &tok);  
void skipspaces();  
  
// Indentation padding string.  
string indent = "";  
   
// Plikowe strumienie  wejciowe i wyjciowe
ifstream fin;  
ofstream fout;  
  
// Klasa wyjtkw obsugujca bdy syntaktyczne.  
class SyntaxExc {  
  string what;  
public:  
  SyntaxExc(char *e) { what = string(e); }  
  string geterror() { return what; }  
};  
  
int main(int argc, char *argv[]) {  
  string token;  
  
  if(argc != 3) {  
    cout << "Uycie: ep <plik wejciowy> <plik wyjciowy>\n";  
    return 1;  
  }  
  
  fin.open(argv[1]);  
  
  if(!fin) {  
    cout << "Nie mona otworzy " << argv[1] << endl;  
    return 1;  
  }  
  
  fout.open(argv[2]);  
  
  if(!fout) {  
    cout << "Nie mona otworzy " << argv[2] << endl;  
    return 1;  
  }  
  
  // Zapisz nagwek  
  fout << "// Zawarto przetumaczona z pliku rdowego .exp.\n";  
  
  try {  
    // Gwna ptla tumaczenia.  
    while(gettoken(token)) {  
  
      // Pomi komentarze // .  
      if(token == "//") {  
        do {  
          fout << token;  
          gettoken(token);  
        } while(token.find('\n') == string::npos);  
        fout << token;  
      }  
  
      // Pomi komentarze /*.  
      else if(token == "/*") {  
        do {  
          fout << token;  
          gettoken(token);  
        } while(token != "*/");  
        fout << token;  
      }  
  
      // Pomi auchcy w znakach cudzysowu.  
      else if(token == "\"") {  
        do {  
          fout << token;  
          gettoken(token);  
        } while(token != "\"");  
        fout << token;  
      }  
  
      else if(token == "foreach") foreach();  
  
      else if(token == "cases") cases();  
  
      else if(token == "repeat") repeat();  
  
      else if(token == "until") until();  
  
      else if(token == "typeof") typeof();  
  
      else fout << token;  
    }  
  } catch(SyntaxExc exc) {  
    cout << exc.geterror() << endl;  
    return 1;  
  }  
  
  return 0;  
}  
  
// Pobierz nastpny eton z acucha wejciowego.  
bool gettoken(string &tok) {  
  char ch;  
  char ch2;  
  static bool trackIndent = true;  
  
  tok = "";  
  
  ch = fin.get();  
  
  // Sprawd, czy wystpi znak koca pliku EOF i zwr warto false,
  //  jeli wystpi. 
  if(!fin) return false;  
  
  // Przeczytaj znak niewidoczny.  
  if(isspace(ch)) {    
    while(isspace(ch)) {  
      tok += ch;  
  
      // Zresetuj licznik wci po kadej nowej linii.  
      if(ch == '\n') {  
        indent = "";  
        trackIndent = true;  
      }  
      else if(trackIndent) indent += ch;  
  
      ch = fin.get();  
    }  
    fin.putback(ch);  
    return true;  
  }  
  
  // Zatrzymaj zliczanie wci po napotkaniu  
  // pierwszego znaku nie bdcego znakiem niewidocznym.  
  trackIndent = false;  
  
  // Przeczytaj identyfikator lun sowo kluczowe. 
  if(isalpha(ch) || ch=='_') {  
    while(isalpha(ch) || isdigit(ch) || ch=='_') {  
      tok += ch;  
      ch = fin.get();  
    }  
    fin.putback(ch);  
    return true;  
  }  
  
  // Przeczytaj liczb.  
  if(isdigit(ch)) {  
    while(isdigit(ch) || ch=='.' ||  
          tolower(ch) == 'e' ||  
          ch == '-' || ch =='+') {  
      tok += ch;  
      ch = fin.get();  
    }  
    fin.putback(ch);  
    return true;  
  }  
  
  // Sprawd , czy wystpuje \"  
  if(ch == '\\') {  
    ch2 = fin.get();  
    if(ch2 == '"') {  
      tok += ch;  
      tok += ch2;  
      ch = fin.get();  
    } else   
      fin.putback(ch2);  
  }  
  
  // Sprawd, czt wystpuje '"'  
  if(ch == '\'') {  
    ch2 = fin.get();  
    if(ch2 == '"') {  
      tok += ch;  
      tok += ch2;  
      return true;  
    } else   
      fin.putback(ch2);  
  }  
  
  // Sprawd, czy wystpuje symbol pocztku komentarza.  
  if(ch == '/') {  
    tok += ch;  
    ch = fin.get();  
    if(ch == '/' || ch == '*') {  
      tok += ch;  
    }  
    else fin.putback(ch);  
    return true;  
  }  
  
  // Sprawd, czy wystpuje znak koca komentarza.  
  if(ch == '*') {  
    tok += ch;  
    ch = fin.get();  
    if(ch == '/') {  
      tok += ch;  
    }  
    else fin.putback(ch);  
    return true;  
  }  
  
  tok += ch;  
  
  return true;  
}   
  
// Przekszta ptl foreach.  
void foreach() {  
  string token;  
  string varname;  
  string arrayname;  
  
  char forvarname[5] = "_i";  
  static char counter[2] = "a";  
  
  // Utwrz zmienn sterujc dla generowanej
  // ptli for.
  strcat(forvarname, counter);  
  counter[0]++;  
  
  // W pliku moe wystpowa maksymalnie 26 ptli foreach, poniewa
  // zbir generowanych zmiennych sterujcych ptli jest ograniczony
  // do przedziau od _ia do _iz. Jeli zajdzie taka potrzeba, mona to zmieni.
  if(counter[0] > 'z')   
    throw SyntaxExc("Zbyt duo wystpie ptli foreach.");  
  
  fout << "int " << forvarname  
       << " = 0;\n";  
  
  // Zapisz pocztek generowanej ptli.  
  fout << indent << "for(";  
  
  skipspaces();  
  
  // Przeczytaj (. 
  gettoken(token);  
  if(token[0] != '(')   
    throw SyntaxExc("W ptli foreach spodziewany znak (.");  
  
  skipspaces();  
  
  // Pobierz typ zmiennej wystpujcej w ptli foreach.   
  gettoken(token);  
  fout << token << " ";  
  
  skipspaces();  
  
  // Odczytaj i zapisz nazw zmiennej sterujcej ptli foreach.  
  gettoken(token);  
  varname = token;  
  
  skipspaces();  
  
  // Przeczytaj acuch "in"  
  gettoken(token);  
  if(token != "in")   
    throw SyntaxExc("w ptli foreach spodziewane wyraenie in.");  
  
  skipspaces();  
  
  // Przeczytaj nazw tablicy.  
  gettoken(token);  
  arrayname = token;  
  
  fout << varname << " = " << arrayname << "[0];\n";  
  
  // Wygeneruj warto docelow licznika.  
  fout << indent + "    " << forvarname << " < "  
       << "((sizeof " << token << ")/"   
       << "(sizeof " << token << "[0]));\n";  
  
  fout << indent + "    " << forvarname << "++, "  
       << varname << " = " << arrayname << "["  
       << forvarname << "])";  
  
  skipspaces();  
  
  // Przeczytaj znak ).
  gettoken(token);  
  if(token[0] != ')')  
    throw SyntaxExc("w ptli foreach spodziewany znak ).");  
}  
  
// Przekszta wyraenie cases.  
void cases() {  
  string token;  
  int start, end;  
  
  skipspaces();  
  
  // Pobierz warto pocztkow.  
  gettoken(token);  
  
  if(isdigit(token[0])) {  
    // czy jest liczb cakowit  
    start = atoi(token.c_str());  
  }  
  else if(token[0] == '\'') {  
    // czy jest znakiem 
    gettoken(token);  
  
    start = (int) token[0];  
  
    // pomi zamykajcy znak ' 
    gettoken(token);  
    if(token[0] != '\'')  
      throw SyntaxExc("spodziewany znak ' w wyraeniu cases");  
  }  
  else  
   throw SyntaxExc("spodziewana warto w wyraeniu cases");  
  
  skipspaces();  
  
  // Przeczytaj i pomi cuch "to".  
  gettoken(token);  
  if(token != "to")  
    throw SyntaxExc("spodziewane \"to\" w wyraeniu cases.");  
  
  skipspaces();  
  
  // Pobierza warto kocow.  
  gettoken(token);  
  
  if(isdigit(token[0])) {  
    // czy jest liczb cakowit  
    end = atoi(token.c_str());  
  }  
  else if(token[0] == '\'') {  
    // czy jest znakiem  
    gettoken(token);  
  
    end = (int) token[0];  
  
    // pomi zamykajcy znak  '  
    gettoken(token);  
    if(token[0] != '\'')  
      throw SyntaxExc("spodziewany znak ' w wyraeniu cases.");  
  }  
  else  
   throw SyntaxExc("spodziewana warto w wyraeiu cases.");  
  
  skipspaces();  
  
  // Przeczytaj i pomi :  
  gettoken(token);  
  
  if(token != ":")   
    throw SyntaxExc("spodziewany znak: w wyraeniu cases.");  
  
  // Wygeneruj "stos" wyrae case.  
  fout << "case " << start << ":\n";  
  for(int i = start+1 ; i <= end; i++) {  
    fout << indent << "case " << i << ":";  
    if(i != end) fout << endl;  
  }  
}  
  
// Przekszta ptl repeat.  
void repeat() {  
  fout << "do";  
}    
  
// Przekszta wyraenie until.  
void until() {  
  string token;  
  int parencount = 1;  
  
  fout << "while";  
  
  skipspaces();  
  
  // Przeczytaj i zapisz znak (  
  gettoken(token);  
  if(token != "(")  
    throw SyntaxExc("spodziewany znak ( w wyraeniu typeof.");  
  fout << "(";  
  
  // Rozpocznij wyraenie while poprzez zanegowaniu warunku
  // i otworzenie nawiasu.  
  fout << "!(";  
  
  // Teraz przeczytaj wyraenie.  
  do {  
    if(!gettoken(token))  
      throw SyntaxExc("Niespodziewany koniec pliku.");  
  
    if(token == "(") parencount++;  
    if(token == ")") parencount--;  
  
    fout << token;  
  } while(parencount > 0);  
  fout << ")";  
}  
  
// Przekzta wyraenie typeof.   
void typeof() {  
  string token;  
  string temp;  
  
  fout << "typeid(";  
  
  skipspaces();  
  
  gettoken(token);  
  
  do {  
    temp = token;  
  
    if(!gettoken(token))  
      throw SyntaxExc("Niespodziewany koniec pliku.");  
    
    if(token != "same") fout << temp;  
  } while(token != "same");  
  
  skipspaces();  
  
  gettoken(token);  
  
  if(token != "as") throw SyntaxExc("spodziewany acuch \"as\".");  
  
  fout << ") == typeid(";  
  
  skipspaces();  
  
  do {  
    if(!gettoken(token))  
      throw SyntaxExc("Niespodziewany koniec pliku.");  
  
    fout << token;  
  } while(token != ")");  
  fout << ")";  
}  
  
void skipspaces() {  
  char ch;  
  
  do {  
    ch = fin.get();  
  } while(isspace(ch));  
  fin.putback(ch);  
}
