// Demonstracja panela kontrolnego wtku.
#include <windows.h>  
#include <process.h> 
#include "thrdapp.h"  
#include "tcp.cpp" 
 
const int MAX = 500000; 
  
LRESULT CALLBACK WindowFunc(HWND, UINT, WPARAM, LPARAM);  
  
unsigned __stdcall MyThread1(void * param);  
unsigned __stdcall MyThread2(void * param);  
  
char str[255]; // przechowuje napisy wyjciowe
  
unsigned tid1, tid2; // identyfikatory wtkw
HANDLE hThread1, hThread2; // uchwyty wtkw
   
HINSTANCE hInst; // uchwyt instancji
 
int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,   
                   LPSTR args, int winMode)  
{  
  HWND hwnd;  
  MSG msg;  
  WNDCLASSEX wcl;  
  HACCEL hAccel;  
  
  // Definicja klasy okna.
  wcl.cbSize = sizeof(WNDCLASSEX);   
  
  wcl.hInstance = hThisInst;     // uchwyt tej instancji
  wcl.lpszClassName = "MyWin";   // nazwa klasy okna
  wcl.lpfnWndProc = WindowFunc;  // funkcja obsugi okna
  wcl.style = 0;                 // domylny styl
  
  wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION); // dua ikona
  wcl.hIconSm = NULL; // uyj maej wersji duej ikony
  wcl.hCursor = LoadCursor(NULL, IDC_ARROW);  // styl kursora
  
  wcl.lpszMenuName = "ThreadAppMenu"; // menu gwne
  
  wcl.cbClsExtra = 0; // nie potrzebna dodatkowa pami
  wcl.cbWndExtra = 0;   
  
  // Ustaw to okna na biae.
  wcl.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);   
  
  // Zarejestruj klas okna.
  if(!RegisterClassEx(&wcl)) return 0;  
  
  /*Teraz gdy klasa okna zostaa zarejestrowana, mona utworzy okno*/  
  hwnd = CreateWindow(  
    wcl.lpszClassName, // nazwa klasy okna
    "Uycie panela kontrolnego wtku", // tytu
    WS_OVERLAPPEDWINDOW, // styl okna - normalny
    CW_USEDEFAULT, // wsprzdna X - niech ustawi system Windows
    CW_USEDEFAULT, // wsprzdna Y - niech ustawi system Windows
    260,           // szeroko
    200,           // wysoko
    NULL,          // brak okna rodzicielskiego
    NULL,          // nie zastpujemy menu klasy
    hThisInst,     // uchwyt instancji
    NULL           // brak dodatkowych argumentw
  );  
  
  hInst = hThisInst; // zapamitanie uchwytu instancji
  
  // Wczytanie skrtw klawiszowych.
  hAccel = LoadAccelerators(hThisInst, "ThreadAppMenu");  
  
  // Wywietlenie okna.
  ShowWindow(hwnd, winMode);  
  UpdateWindow(hwnd);  
  
  // Utwrz ptl komunikatw.
  while(GetMessage(&msg, NULL, 0, 0))  
  {  
    if(!TranslateAccelerator(hwnd, hAccel, &msg)) {  
      TranslateMessage(&msg); // przetumacz komunikaty z klawiatury
      DispatchMessage(&msg); // zwr kontrol systemowi Windows
    }  
  }  
  
  return msg.wParam;  
}  
  
/*Ta funkcja jest wywoywana przez system Windows i s jej
   przekazywane komunikaty z pli komunikatw.  
*/  
LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message,  
                            WPARAM wParam, LPARAM lParam)  
{  
  int response;  
  
  switch(message) {  
    case WM_COMMAND:  
      switch(LOWORD(wParam)) {  
        case IDM_THREAD: // utwrz wtki
          hThread1 = (HANDLE) _beginthreadex(NULL, 0,   
                               MyThread1, (void *) hwnd, 
                               0, &tid1);  
          hThread2 = (HANDLE) _beginthreadex(NULL, 0,   
                               MyThread2, (void *) hwnd, 
                               0, &tid2);  
          break;  
        case IDM_PANEL: // uaktywnij panel kontrolny
          ThrdCtrlPanel(hInst, hThread1); 
          ThrdCtrlPanel(hInst, hThread2); 
          break;  
        case IDM_EXIT:    
          response = MessageBox(hwnd, "Zakoczy program?",  
                                "Zakocz", MB_YESNO);  
          if(response == IDYES) PostQuitMessage(0);  
          break;  
        case IDM_HELP:   
          MessageBox(hwnd,  
                     "F1: Pomoc\nF2: Uruchom wtki\nF3: Panel",  
                     "Pomoc", MB_OK);  
          break;  
      }  
      break;  
    case WM_DESTROY: // zakocz program
      PostQuitMessage(0);  
      break;  
    default:   
     return DefWindowProc(hwnd, message, wParam, lParam);  
  }  
  
  return 0;  
}  
  
// Pierwszy wtek.
unsigned __stdcall MyThread1(void * param)  
{  
  int i;    
  HDC hdc;  
  
  for(i=0; i<MAX; i++) {  
    wsprintf(str, "Wtek 1: licznik ptli # %5d ", i);  
    hdc = GetDC((HWND) param);  
    TextOut(hdc, 1, 1, str, lstrlen(str));  
    ReleaseDC((HWND) param, hdc);  
  }  
  
  return 0;  
}  
  
// Drugi wtek.
unsigned __stdcall MyThread2(void * param)  
{  
  int i;  
  HDC hdc;  
  
  for(i=0; i<MAX; i++) {  
    wsprintf(str, "Wtek 2: licznik ptli # %5d ", i);  
    hdc = GetDC((HWND) param);  
    TextOut(hdc, 1, 20, str, lstrlen(str));  
    ReleaseDC((HWND) param, hdc);  
  }  
  
  return 0;  
} 

