// Uycie wskanika GCPtr z typem klasowym.
#include <iostream> 
#include <new> 
#include "gc.h" 
 
using namespace std; 
 
class MyClass { 
  int a, b; 
public: 
  double val; 
 
  MyClass() { a = b = 0; } 
 
  MyClass(int x, int y) { 
    a = x; 
    b = y; 
    val = 0.0; 
  } 
 
  ~MyClass() { 
    cout << "Destruktor klasy MyClass(" << 
         a << ", " << b << ")\n"; 
  } 
 
  int sum() { 
    return a + b; 
  } 
 
  friend ostream &operator<<(ostream &strm, MyClass &obj); 
}; 
 
// Przeciony wyjciowy operator strumieniowy do wywietlenia klasy MyClass.
ostream &operator<<(ostream &strm, MyClass &obj) { 
  strm << "(" << obj.a << " " << obj.b << ")"; 
  return strm; 
} 
 
int main() { 
  try { 
    GCPtr<MyClass> ob = new MyClass(10, 20); 
 
    // Poka warto przy uyciu przecionego operatora strumieniowego.
    cout << *ob << endl; 
 
    // Zmie obiekt wskazywany przez zmienn ob.
    ob = new MyClass(11, 21); 
    cout << *ob << endl; 
 
    // Wywoaj funkcj skadow przez wskanik GCPtr.
    cout << "Suma wynosi : " << ob->sum() << endl; 
 
    // przypisz warto zmiennej skadowej przez wskanik GCPtr.
    ob->val = 98.6; 
    cout << "ob->val: " << ob->val << endl; 
 
    cout << "ob jest teraz " << *ob << endl; 
  } catch(bad_alloc exc) { 
    cout << "Bd alokacji pamici!\n"; 
    return 1; 
  } 
 
  return 0; 
}

