/********************************************************
 * char_type -- modul rozpoznajacy typ znaku	        *
 ********************************************************/
enum CHAR_TYPE {
    C_EOF,	/* koniec pliku zawierajacego znaki */
    C_WHITE,	/* spacja lub znak sterujacy */
    C_NEWLINE,	/* znak nowej linii */
    C_ALPHA,	/* litera (lacznie ze znakiem _) */
    C_DIGIT,	/* liczba */
    C_OPERATOR,	/* losowo wybrany operator */
    C_SLASH,	/* znak '/' */
    C_L_PAREN,	/* znak '(' */
    C_R_PAREN,	/* znak ')' */
    C_L_CURLY,	/* znak '{' */
    C_R_CURLY,	/* znak '}' */
    C_SINGLE,	/* znak '\'' */
    C_DOUBLE,	/* znak '"' */
    /* koniec typow prostych, dalej zawarto typy bardziej zlozone */
    C_HEX_DIGIT,/* liczba szesnastkowa */
    C_ALPHA_NUMERIC/* znak alfanumeryczny */
};

/******************************************************** 
 * is_char_type -- sprawdza czy znak nalezy do          *
 * 		podanego typu.			              *
 *							              *  
 * Parametry						        *
 *	ch -- sprawdzany znak			              *
 *	kind -- sprawdzany typ			              *
 *							              *
 * Wartosc zwracana:					        *
 *	0 -- znak nie nalezy do podanego typu	        *
 *	1 -- znak nalezy do podanego typu.	              *
 ********************************************************/
extern int is_char_type(int ch, enum CHAR_TYPE kind);

/********************************************************
 * get_char_type -- dla danego znaku zwraca jego typ.   *
 *							              *
 * Uwaga: Zwraca tylko typy proste. Typy zlozone takie  *
 * jak C_HEX_DIGIT i C_ALPHA_NUMERIC nie sa	        *
 * zwracane.						        *
 *							              *
 * Parametry:						        *
 *	ch -- znak okreslonego typu.		              *
 *							              *
 * Wartosc zwracana					        *
 *	typ znaku.					              *
 ********************************************************/
extern enum CHAR_TYPE get_char_type(int ch);
