/***************************************************************
 * Definiuje, stosuje i wyswietla uporzadkowane listy dowiazan *
 *							                     * 
 * Zastosowanie:						               *
 *	list						                     *
 *							                     *
 * Uwaga: Prezentacja uporzadkowanej listy dowiazan	         *
 ***************************************************************/
#include <stdio.h>
#include <stdlib.h>

/********************************************************
 * Pozycja dla listy dowiazan				        *
 ********************************************************/
struct item {
    int value;			/* wartosc pozycji */
    struct item *next_ptr;	/* wskaznik do nastepnej pozycji */
};

/***************************************************************
 * enter -- wstawia wartosc na liste dowiazan.		         * 
 *							                     *
 * Parametry						               *
 *	first_ptr -- wskaznik do naglowka listy	               *
 *	value --  wartosc dodawana do listy		               *
 *							                     *
 * Ograniczenia: Pierwsza pozycja musi miec najnizsza wartosc. *
 *	Lista musi juz zawierac jedna pozycje.		         *
 ***************************************************************/
void enter(struct item *first_ptr, const int value)
{
    struct item *before_ptr;		/* Jedna pozycja przed aktualna */
    struct item *after_ptr;		/* Jedna pozycja za aktualna */
    struct item *new_item_ptr;		/* Dodawana pozycja */

    /* Tworzenie nowych pozycji dodawanych do listy */

    before_ptr = first_ptr;		/* Rozpoczyna od poczatku */
    after_ptr =  before_ptr->next_ptr;	

    while (1) {
	if (after_ptr == NULL)
	    break;

	if (after_ptr->value >= value)
	    break;

	/* wskazniki do pozycji przed i za aktualna pozycja */
	after_ptr = after_ptr->next_ptr;
	before_ptr = before_ptr->next_ptr;
    }

    new_item_ptr = malloc(sizeof(struct item));
    new_item_ptr->value = value;	/* Ustawia wartosc pozycji */

    before_ptr->next_ptr = new_item_ptr;
    new_item_ptr->next_ptr = after_ptr;
}
/********************************************************
 * print -- wyswietla liste dowiazan			  *
 *							              *
 * Parametr						              *
 *	first_ptr -- wskaznik do pierwszej pozycji	  *
 *			 na liscie 				        *
 ********************************************************/
void print(struct item *first_ptr)
{
    struct item *cur_ptr;	/* Wskaznik do aktualnej pozycji */

    for (cur_ptr = first_ptr; cur_ptr != NULL; cur_ptr = cur_ptr->next_ptr) 
	printf("%d ", cur_ptr->value);
    printf("\n");
}

int main()
{
    /* lista dowiazan */
    struct item *head_ptr = NULL;

    head_ptr = malloc(sizeof(struct item));

    head_ptr->value = 0;
    head_ptr->next_ptr = NULL;

    enter(head_ptr, 5);
    enter(head_ptr, 4);
    enter(head_ptr, 8);
    enter(head_ptr, 9);
    enter(head_ptr, 1);
    enter(head_ptr, 2);

    print(head_ptr);
    return (0);
}
