/*-*/
/****************************************************************
 * Nazwa: Zero arrays.					                *  
 *							                      *
 * Cel: Prezentuje dwie metody czyszczenia zawartosci tablicy.  *
 *							                      *
 * Zastosowanie: Uruchomienie programu do niczego sie nie       *
 *          przyda. Zanalizuj program za pomoca debuggera.	    *
 ***************************************************************/
/*+*/
#define MAX 10	/* Rozmiar tablicy */
/********************************************************
 * init_array_1 -- Tablica bez wartosci zero            *
 *                                                      *
 * Parametry                                            *
 *      data -- tablica rowna zero                      *
 ********************************************************/
void init_array_1(int data[])
{
    int  index;

    for (index = 0; index < MAX; ++index)
        data[index] = 0;
}

/*********************************************************
 * init_array_2 -- Tablica bez wartosci zero             *
 *                                                       *
 * Parametry                                            *
 *      data_ptr -- wskaznik do tablicy rownej zero      *
 *********************************************************/
void init_array_2(int *data_ptr)
{
    int index;

    for (index = 0; index < MAX; ++index)
        *(data_ptr + index) = 0;
}
int main()
{
    int  array[MAX];

    void init_array_1();
    void init_array_2();

    /* pierwsza metoda inicjalizacji tablicy */
    init_array_1(array);

    /* druga metoda inicjalizacji tablicy */
    init_array_1(&array[0]);

    /* tez dziala, ale kompilator wygeneruje ostrzezenie */
    init_array_1(&array);

    /* podobnie jak w pierwszej metodzie, ale */
    /* funkcja jest inna */
    init_array_2(array);

    return (0);
}
