/****************************************************************
 * infinite-array -- funkcje obslugujace tablice nieograniczone *
 *                                                              *
 * Tablica nieograniczona jest tablica, ktorej rozmiar          *
 * zmienia sie w sposob dynamiczny. W przypadku tablicy         *
 * nieograniczonej nie ma zbyt duzego indeksu                   *
 * (chyba ze zabraknie pamieci).                                *
 ****************************************************************/
#include "ia.h"                 /* pobranie ogolnych definicji */
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>     

/********************************************************
 * ia_locate -- pobiera lokalizacje elementu            *
 *              tablicy nieograniczonej.                *
 *                                                      *
 * Parametry                                            *
 *      array_ptr -- wskaznik do zastosowanej tablicy   *
 *      index   -- indeks tablicy                       *
 *      current_index -- wskaznik do indeksu biezacego  *
 *              wiadra(warto zwrocona)                *
 *                                                      *
 * Wartosc zwracana                                     *
 *      wskaznik do biezacego wiadra                    *
 ********************************************************/
static struct infinite_array *ia_locate(
        struct infinite_array *array_ptr, int index,
        int *current_index_ptr)
{
    /* wskaznik do biezacego wiadra */
    struct infinite_array *current_ptr;

    current_ptr = array_ptr;
    *current_index_ptr = index;

    while (*current_index_ptr >= BLOCK_SIZE) {
        if (current_ptr->next == NULL) {

            current_ptr->next = malloc(sizeof(struct infinite_array));

            if (current_ptr->next == NULL) {
                fprintf(stderr, "Blad:Brak pamieci\n");
                exit(8);
            }

	    memset(current_ptr->next, '\0', sizeof(struct infinite_array));
        }
        current_ptr = current_ptr->next;
        *current_index_ptr -= BLOCK_SIZE;
    }
    return (current_ptr);
}
/***********************************************************
 * ia_store -- zapisuje element w tablicy nieograniczonej. *
 *                                                         *
 * Parametry                                               *
 *      array_ptr -- wskaznik do zastosowanej tablicy      *
 *      index   -- indeks tablicy                          * 
 *      store_data -- zapisywane dane                      *
 ***********************************************************/
void  ia_store(struct infinite_array * array_ptr, 
    int index, int store_data)
{
    /* wskaznik do biezacego wiadra */
    struct infinite_array *current_ptr;
    int   current_index;        /* indeks biezacego wiadra */

    current_ptr = ia_locate(array_ptr, index, &current_index);
    current_ptr->data[current_index] = store_data;
}
/**********************************************************
 * ia_get -- pobiera element tablicy nieograniczonej.     *
 *                                                        *
 * Parametry                                              *
 *      array_ptr -- wskaznik do zastosowanej tablicy     *
 *      index   -- indeks tablicy                         *
 *                                                        *
 * Wartosc zwracana                                       *
 *      wartosc elementu                                  *
 *							     *
 * Uwaga: Mozliwe jest pobranie elementu, ktory	     *
 *	nie zostal wczesniej zapisany.  Wartosc kadego  *
 *	niezainicjalizowanego elementu jest rowna 0.	     *
 **********************************************************/
int ia_get(struct infinite_array *array_ptr, int index)
{
    /* wskaznik do biezacego wiadra */
    struct infinite_array *current_ptr;

    int   current_index;        /* indeks biezacego wiadra */

    current_ptr = ia_locate(array_ptr, index, &current_index);
    return (current_ptr->data[current_index]);
}
