/***********************************************************
 * token -- modul przetwarzajacy znaczniki	           * 
 *							                 *
 * Funkcja:						                 *
 *	next_token -- pobiera nastepny znacznik z wejscia    *
 **********************************************************/

/*
 * Definiuje liste znacznikow typu wyliczeniowego.
 */
enum TOKEN_TYPE {
   T_NUMBER,	/* liczba prosta (calkowita lub zmiennoprzecinkowa */
   T_STRING,	/* lancuch lub stala znakowa */
   T_COMMENT,	/* komentarz */
   T_NEWLINE,	/* znak nowej linii */
   T_OPERATOR,	/* operator arytmetyczny */
   T_L_PAREN,	/* znak "(" */
   T_R_PAREN,	/* znak ")" */
   T_L_CURLY,	/* znak "{" */
   T_R_CURLY,	/* znak "}" */
   T_ID,		/* identyfikator */
   T_EOF		/* koniec pliku */
};

/*
 * Zamiast instrukcji "const int" zostala zastosowana dyrektywa #define, 
 * poniewaz stosuje ja wiele starszych aplikacji. Konieczne bylo 
 * wybranie pliku naglowkowego, ktry wykorzystuje dyrektywe #define
 * dla wartosci TRUE/FALSE. Niezaleznie od tego unikamy stosowania 
 * powtorzen definicji oraz dyrektywy #define. 
 */
#ifndef TRUE
#define TRUE 1		/* definicja prostych wartosci TRUE/FALSE */
#define FALSE 0
#endif /* wartosc TRUE */

/*********************************************************************
 * next_token -- wczytuje nastepny znacznik z wejsciowego strumienia *
 *							                           *
 * Parametry						                     *
 *	in_file -- wczytywany plik				               *
 *							                           *
 * Wartosc zwracana						               *
 *	nastepny znacznik					                     *
 *********************************************************************/
extern enum TOKEN_TYPE next_token(void);
