/*-*/
/*********************************************************
 * split -- dzieli wpis o postaci Nazwisko/Imie          *
 *      na dwie czesci.                                  *
 *							               *
 * Zastosowanie: Uruchom program. Po wprowadzeniu 	   *
 *		imienia i nazwiska w postaci Nazwisko/Imie . *
 *	      nastapi ich podzial	                     *
 ********************************************************/
/*+*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/********************************************************
 * my_strchr -- szuka znaku w lancuchu                  *
 *      Kopia funkcji standardowej,                     *
 *      utworzona dla celow demonstracyjnych.           *
 *                                                      *
 * Parametry                                           *
 *      string_ptr -- lancuch wyszukujacy               *
 *      find -- szukany znak                            *
 *                                                      *
 * Wartosc zwracana                                     *
 *      wskaznik wskazujacy pierwsze wystapienie znaku  *
 *      w lancuchu lub wartosc NULL w przypadku bledu   *
 ********************************************************/
char *my_strchr(char * string_ptr, char find)
{
    while (*string_ptr != find) {

       /* kontrola konca lancucha */

       if (*string_ptr == '\0')
           return (NULL);       /* nie znaleziony */

        ++string_ptr;
    }
    return (string_ptr);        /* znaleziony */
}

int main()
{
    char line[80];      /* dane wejsciowe */
    char *first_ptr;    /* wskaznik do imienia */
    char *last_ptr;     /* wskaznik do nazwiska */

    fgets(line, sizeof(line), stdin);

    /* usuniecie znaku nowej linii */
    line[strlen(line)-1] = '\0';        

    last_ptr = line;    /* nazwisko na poczatku wiersza */

    first_ptr = my_strchr(line, '/');      /* szuka znaku / */

    /* wykrywanie bledu */
    if (first_ptr == NULL) {
        fprintf(stderr,
            "Blad: Nie znaleziono znaku / w %s\n", line);
        exit (8);
    }

    *first_ptr = '\0';  /* ustawienie wartosci zero */

    ++first_ptr;        /* przesuniecie do pierwszego znaku imienia */

    printf("Imie:%s Nazwisko:%s\n", first_ptr, last_ptr);
    return (0);
}
