/*************************************************************
 * search -- Szuka zestawu liczb. 			             *
 *							                   *
 * Zastosowanie:						             *
 *	search						             *
 *		Zostaniesz poproszony o podanie 	             *  
 *		szukanych liczb.			                   *
 * Pliki:						                   *
 *     numbers.dat - zawiera szukane liczby, 1 liczba/wiersz *
 *			(liczby musza byc uporzadkowane)	       *
 *************************************************************
#include <stdio.h>
#define MAX_NUMBERS	 1000	            /* maksymalna ilosc liczb w pliku */
const char DATA_FILE[] = "numbers.dat";	/* plik zawierajacy liczby */

int data[MAX_NUMBERS];	/* tablica szukanych liczb */
int max_count;		/* ilosc dopuszczalnych elementow */
int main()
{
    FILE *in_file;	/* plik wejsciowy */
    int	middle;     /* srodek przeszukiwanego zakresu */
    int low, high;	/* gorna/dolna granica */
    int search;		/* szukana liczba */
    char line[80];	/* wprowadzone dane */

    in_file = fopen(DATA_FILE, "r");
    if (in_file == NULL) {
	fprintf(stderr,"Blad:Nie mozna otworzyc pliku %s\n", DATA_FILE);
	exit (8);
    }

    /*
     * Wczytanie danych 
     */

    max_count = 0;
    while (1) {
	if (fgets(line, sizeof(line),  in_file) == NULL)
	    break;

	/* konwersja liczby */
	sscanf(line, "%d", &data[max_count]);
	++max_count;
    }

    while (1) {
	printf("Podaj szukana liczbe lub wpisz -1, aby zakonczyc program:" );
	fgets(line, sizeof(line), stdin);
	sscanf(line, "%d", &search);

	if (search == -1)
	    break;

	low = 0;
	high = max_count;

	while (1) {
	    middle = (low + high) / 2;

	    if (data[middle] == search) {
		printf("Liczba znaleziona na pozycji %d\n", middle);
		break;
	    }

	    if (low == high) {
		printf("Nie znaleziono\n");
		break;
	    }

	    if (data[middle] < search)
		low = middle;
	    else
		high = middle;
	}
   }
   return (0);
}
