/*-*/
/***********************************************************
 * Program: Parse Arguments.				           *
 *							                 *
 * Program jest przykladem programu dokonujacego rozkladu  *
 * argumentow linii polecen. Program definiuje wszystkie   *
 * zmienne globalne programu, ale nie posiada 	           *
 * instrukcji.					                 *
 ***********************************************************/

/*+*/
/********************************************************
 * Program: Print					   *
 *							   *
 * Cel:				      		          *
 *	formatuje plik do wydruku			   *
 *							   *
 * Zastosowanie:						   *
 *	print [opcje] plik(i)				   *
 *							   *
 * Opcje:						   *
 *	-v		wlacza tryb pelnej informacji	   *
 *	-o<plik>	wysyla dane wyjsciowe do pliku   *
 *			(plik domyslny=print.out)	   *
 *	-l<linie>	ustawia ilosc linii na strone.   *
 *			(wartosc domyslna=66).		   *
 ********************************************************/
#include <stdio.h>
#include <stdlib.h>      

int verbose = 0;                /* tryb pelnej informacji (domyslnie = wylaczony) */
char *out_file = "print.out";   /* nazwa pliku wyjsciowego */
char *program_name;             /* nazwa programu (dla bledow) */ 
int line_max = 66;              /* ilosc linii na strone */

/********************************************************
 * do_file -- fikcyjna funkcja obslugujaca plik         *
 *                                                      *
 * Parametr                                             *
 *      name -- nazwa pliku do wydruku                   *
 ********************************************************/
void do_file(char *name)
{
    printf("Tryb pelnej informacji %d Linie %d Plik wejsciowy %s Plik wyjsciowy %s\n",
        verbose, line_max, name, out_file);
}
/*************************************************************
 * zastosowanie - powiedz uzytkownikowi jak uzywac programu  *
 *              i nastepnie go zamknij                       *
 *************************************************************/
void usage(void)
{
    fprintf(stderr,"Program ma format: %s [opcje] [lista plikow]\n", 
                                program_name);
    fprintf(stderr,"Opcje\n");
    fprintf(stderr,"  -v          Tryb pelnej informacji\n");
    fprintf(stderr,"  -l<liczba>  Ilosc linii\n");
    fprintf(stderr,"  -o<nazwa>    Ustawia nazwe pliku wyjsciowego\n");
    exit (8);
}
int main(int argc, char *argv[])
{
    /* zapisanie nazwy programu dla przyszlych zastosowan */
    program_name = argv[0];

    /* 
     *   Petla wykonywana dla kazdej opcji.  
     *   Jest przerywana jesli braknie argumentow
     *   lub jesli pobierze argument bez znaku -.
     */
    while ((argc > 1) && (argv[1][0] == '-')) {
        /*
         * argv[1][1] jest faktycznym znakiem opcji
         */
        switch (argv[1][1]) {
            /*
             * -v tryb pelnej informacji 
             */
            case 'v':
                verbose = 1; 
                break;
            /*
             * -o<nazwa>  nazwa pliku wyjsciowego
             *    [0] jest znakiem -
             *    [1] jest znakiem o
             *    [2] poczatek nazwy pliku
             */
            case 'o':
                out_file = &argv[1][2];
                break;
            /*
             * -l<liczba> ustawia maksymalna ilosc linii
             */
            case 'l':
                line_max = atoi(&argv[1][2]);
                break;
            default:
                fprintf(stderr,"Nieprawidlowa opcja %s\n", argv[1]);
                usage();
        }
        /*
         * przesuwa liste argumentow o jeden w gore
         * zmniejsza licznik o jeden
         */
        ++argv;
        --argc;
    }

    /*
     * W tym miejscu wszystkie opcje zostaly przetworzone.
     * Nalezy sprawdzic czy na liscie nie ma juz zadnych plikow.
     * Jesli ich nie ma, wtedy nalezy przetworzyc dane ze standardowego wejscia.
     */
    if (argc == 1) {
        do_file("print.in");
    } else {
        while (argc > 1) {
          do_file(argv[1]);
          ++argv;
          --argc;
        }
    }
    return (0);
}
