/********************************************************
 * definicje modulu obslugi tablicy nieograniczonej (ia)*
 *                                                      *
 * Tablica nieograniczona jest tablica, ktorej rozmiar  *
 * zmienia sie w sposob dynamiczny. Dodanie kolejnych   *
 * elementow zwiekszy jej rozmiar.                      *
 *------------------------------------------------------*
 * struct infinite_array                                *
 *      stosowana do przechowywania danych tablicy      *
 *      nieograniczonej                                 *
 *------------------------------------------------------*
 * Funkcje                                              *
 *                                                      *
 *      ia_init -- inicjalizuje tablice		   *
 *      ia_store -- zapisuje w tablicy element          *
 *      ia_get -- pobiera element tablicy            	   *
 ********************************************************/

/* liczba elementow, ktora zostanie zapisana w kazdej komorce tablicy nieograniczonej */
#define BLOCK_SIZE      10 
	
struct infinite_array {
    /* dane w tym bloku */
    float   data[BLOCK_SIZE];       

    /* wskaznik do nastepnej tablicy */
    struct infinite_array *next;
};

/********************************************************
 * ia_init -- inicjalizacja tablicy nieograniczonej.    *
 * Parametry						   *
 *	array_ptr -- inicjalizowana tablica		   *
 ********************************************************/
#define ia_init(array_ptr)      {(array_ptr)->next = NULL;}

/********************************************************
 * ia_get -- pobiera element tablicy nieograniczonej.   *
 *                                                      *
 * Parametry                                            *
 *      array_ptr -- wskaznik do zastosowanej tablicy   *
 *      index   -- indeks tablicy                       *
 *                                                      *
 * Wartosc zwracana                                     *
 *      wartosc elementu                                *
 *							   *
 * Uwaga: Mozliwe jest pobranie elementu, ktory	   *
 *	nie zostal wczesniej zapisany.  Wartosc kadego *
 *	niezainicjalizowanego elementu jest rowna 0.	   *
 ********************************************************/
extern int ia_get(struct infinite_array *array_ptr, int index);

/**********************************************************
 * ia_store -- zapisuje element w tablicy nieograniczonej *
 *                                                        *
 * Parametry                                              *
 *      array_ptr -- wskaznik do zastosowanej tablicy     *
 *      index   -- indeks tablicy                         *
 *      store_data -- zapisywane dane                     *
 ********************************************************/
extern void  ia_store(struct infinite_array * array_ptr, 
    int index, int store_data);
