/*-*/
/********************************************************
 * Nazwa: Graph						        *
 *							              *
 * Cel:						              *
 *	Prezentacja zastosowania bitmapy.	              *
 *							              *
 * Algorytm: Definiuje tablice bitow dla bitmapy, 	  *
 *	rysuje przekatne w poprzek tablicy,	              *
 *	a nastepnie wyswietla wynik.				  *
 *							              *
 * Zastosowanie:						        *
 *	Uruchom program i spojrz na wyswietlony obraz.	  *
 ********************************************************/
/*+*/
#include <stdio.h>

#define X_SIZE 40  /* wymiar tablicy w kierunku osi X */
#define Y_SIZE 60  /* wymiar tablicy w kierunku osi Y */
/*
 * Ze wzgledu na umieszczanie 8 bitow w bajcie stosujemy X_SIZE/8
 */
char graphics[X_SIZE / 8][Y_SIZE];   /* dane bitmapy */

#define SET_BIT(x,y) graphics[(x)/8][y] |= (0x80 >>((x)%8))

int main()
{
    int   loc;        /* aktualnie ustawiane polozenie */
    void  print_graphics(void); /* wyswieltenie danych */

    for (loc = 0; loc < X_SIZE; ++loc)
        SET_BIT(loc, loc);

    print_graphics();
    return (0);
}
/*******************************************************************
 * funkcja print_graphics -- wyswietla bitmape skladajaca sie       *
 * z tablicy bitow (zbioru zawierajacego znaki X i .).         *
 *******************************************************************/
void print_graphics(void)
{
    int x;              /* aktualna wartosc wspolrzednej x */
    int y;              /* aktualna wartosc wspolrzednej y */
    unsigned int bit;   /* bit sprawdzany w aktualnym bajcie */

    for (y = 0; y < Y_SIZE; ++y) {
        /* petla wykonywana dla kazdego bajtu tablicy */
        for (x = 0; x < X_SIZE / 8; ++x) {
            /* przetwarzanie kazdego bitu */
            for (bit = 0x80; bit > 0; bit = (bit >> 1)) {
                if ((graphics[x][y] & bit) != 0)
                    printf("X");
                else
                    printf(".");
            }
        }
        printf("\n");
    }
}
