// Projekt: Binary_Search_Tree.cbp
// Plik   : BSTNode.cpp

#include "BSTNode.h"

BST::BST() : root(NULL)
{
}

BSTNode * BST::Insert(BSTNode * node, int key)
{
    // Jeśli BST nie istnieje, tworzy nowy węzeł jako korzeń.
    // Jeśli węzeł nie ma dziecka, można w takim miejscu wstawić nowy węzeł.
    if(node == NULL)
    {
        node = new BSTNode;
        node->Key = key;
        node->Left = NULL;
        node->Right = NULL;
        node->Parent = NULL;
    }
    // Jeśli wartość wskazanego klucza jest większa od wartości klucza węzła, przechodzimy do prawego poddrzewa.
    else if(node->Key < key)
    {
        node->Right = Insert(node->Right, key);
        node->Right->Parent = node;
    }
    // Jeśli wartość wskazanego klucza jest mniejsza od wartości klucza węzła, przechodzimy do lewego poddrzewa.
    else
    {
        node->Left = Insert(node->Left, key);
        node->Left->Parent = node;
    }

    return node;
}

void BST::Insert(int key)
{
    // Wywołuje funkcję Insert(), której przekazuje węzeł korzenia i klucz.
    root = Insert(root, key);
}

void BST::PrintTreeInOrder(BSTNode * node)
{
    // Przestaje wyświetlać wyniki, jeśli nie znajduje węzła.
    if(node == NULL)
        return;

    // Pobiera najpierw klucz o najmniejszej wartości, który znajduje się w lewym poddrzewie.
    PrintTreeInOrder(node->Left);

    // Wyświetla klucz.
    std::cout << node->Key << " ";

    // Przechodzi do klucza o największej wartości, który znajduje się w prawym poddrzewie.
    PrintTreeInOrder(node->Right);
}

void BST::PrintTreeInOrder()
{
    // Przechodzi po BST, zaczynając od węzła korzenia, i wyświetla wszystkie klucze.
    PrintTreeInOrder(root);
    std::cout << std::endl;
}

BSTNode * BST::Search(BSTNode * node, int key)
{
    // Nie znaleziono wskazanego klucza w BST.
    if (node == NULL)
        return NULL;
    // Znaleziono wskazany klucz.
    else if(node->Key == key)
        return node;
    // Podany klucz ma większą wartość od klucza bieżącego węzła.
    else if(node->Key < key)
        return Search(node->Right, key);
    // Podany klucz ma mniejszą wartość od klucza bieżącego węzła.
    else
        return Search(node->Left, key);
}

bool BST::Search(int key)
{
    // Wywołuje operację Search() i przekazuje jej węzeł korzenia.
    BSTNode * result = Search(root, key);

    // Jeśli znaleziono klucz, zwraca true; w przeciwnym przypadku zwraca false.
    return result == NULL ?
        false :
        true;
}

int BST::FindMin(BSTNode * node)
{
    if(node == NULL)
        return -1;
    else if(node->Left == NULL)
        return node->Key;
    else
        return FindMin(node->Left);
}

int BST::FindMin()
{
    return FindMin(root);
}

int BST::FindMax(BSTNode * node)
{
    if(node == NULL)
        return -1;
    else if(node->Right == NULL)
        return node->Key;
    else
        return FindMax(node->Right);
}

int BST::FindMax()
{
    return FindMax(root);
}

int BST::Successor(BSTNode * node)
{
    // Następnik ma najmniejszą wartość klucza w prawym poddrzewie.
    if (node->Right != NULL)
    {
        return FindMin(node->Right);
    }
    // Jeśli nie ma poddrzewa po prawej:
    else
    {
        BSTNode * parentNode = node->Parent;
        BSTNode * currentNode = node;

        // Jeśli currentNode nie jest korzeniem, a jest prawym dzieckiem, przechodzi wyżej.
        while ((parentNode != NULL) &&
            (currentNode == parentNode->Right))
        {
            currentNode = parentNode;
            parentNode = currentNode->Parent;
        }

        // Jeśli parentNode nie jest NULL, to klucz parentNode jest następnikiem węzła.
        return parentNode == NULL ?
            -1 :
            parentNode->Key;
    }
}

int BST::Successor(int key)
{
    // Szuka najpierw węzła klucza.
    BSTNode * keyNode = Search(root, key);

    // Zwraca klucz. Jeśli klucz nie został znaleziony lub nie znaleziono jego następnika, zwraca -1.
    return keyNode == NULL ?
        -1 :
        Successor(keyNode);
}

int BST::Predecessor(BSTNode * node)
{
    // Poprzednik ma największą wartość klucza w lewym poddrzewie.
    if (node->Left != NULL)
    {
        return FindMax(node->Left);
    }
    // Jeśli nie ma poddrzewa po lewej:
    else
    {
        BSTNode * parentNode = node->Parent;
        BSTNode * currentNode = node;

        // Jeśli currentNode nie jest korzeniem, a jest lewym dzieckiem, przechodzi wyżej.
        while ((parentNode != NULL) &&
            (currentNode == parentNode->Left))
        {
            currentNode = parentNode;
            parentNode = currentNode->Parent;
        }

        // Jeśli parentNode nie jest NULL, to klucz parentNode jest poprzednikiem węzła.
        return parentNode == NULL ?
            -1 :
            parentNode->Key;
    }
}

int BST::Predecessor(int key)
{
    // Szuka najpierw węzła klucza.
    BSTNode * keyNode = Search(root, key);

    // Zwraca klucz. Jeśli klucz nie został znaleziony lub nie znaleziono jego poprzednika, zwraca -1.
    return keyNode == NULL ?
        -1 :
        Predecessor(keyNode);
}

BSTNode * BST::Remove(
    BSTNode * node,
    int key)
{
    // Wskazany węzeł nie został znaleziony w BST.
    if (node == NULL)
        return NULL;

    // Znaleziono wskazany węzeł.
    if (node->Key == key)
    {
        // Jeśli węzeł jest liściem, można go bezpiecznie usunąć.
        if (node->Left == NULL && node->Right == NULL)
            node = NULL;
        // Jeśli węzeł ma tylko jedno dziecko po prawej:
        else if (node->Left == NULL && node->Right != NULL)
        {
            // Jedyne dziecko zostaje bezpośrednio podłączone do rodzica swojego rodzica.
            node->Right->Parent = node->Parent;

            // Pomija węzeł.
            node = node->Right;
        }
        // Jeśli węzeł ma tylko jedno dziecko po lewej:
        else if (node->Left != NULL && node->Right == NULL)
        {
            // Jedyne dziecko zostaje bezpośrednio podłączone do rodzica swojego rodzica.
            node->Left->Parent = node->Parent;

            // Pomija węzeł.
            node = node->Left;
        }
        // Jeśli węzeł ma dwoje dzieci (lewe i prawe):
        else
        {
            // Wyszukuje następnik i poprzednik, aby uniknąć błędu.
            int successorKey = Successor(key);

            // Zastępuje klucz węzła kluczem następnika.
            node->Key = successorKey;

            // Usuwa klucz starego następnika.
            node->Right = Remove(node->Right, successorKey);
        }
    }
    // Jeśli wartość klucza docelowego węzła jest mniejsza od wartości podanego klucza, szukanie odbywa się w prawo:
    else if (node->Key < key)
        node->Right = Remove(node->Right, key);
    // Jeśli wartość klucza docelowego węzła jest większa od wartości podanego klucza, szukanie odbywa się w lewo:
    else
        node->Left = Remove(node->Left, key);

    // Zwraca zaktualizowane BST.
    return node;
}

void BST::Remove(int key)
{
    root = Remove(root, key);
}



