// Projekt: Subsequence_Generator.cbp
// Plik   : Subsequence_Generator.cpp

#include <iostream>
#include <vector>
#include <cmath>

using namespace std;

vector<string> GenerateSubsequences(
   string str)
{
   // Warto zwrotna przechowywana jest
   // w vecString.
   vector<string> vecString;

   // Zwraca dugo str.
   int strLen = str.size();

   // bitCounter uywany jest do sprawdzania
   // pooenia znaku.
   int bitCounter = pow(2, strLen);

   // Sprawdza od 000..001 do 111..111.
   // Pusty podzbir jest ignorowany.
   for (int i = 1; i < bitCounter; ++i)
   {
      // Tymczasowa zmienna,
      // przechowujca biec podsekwencj.
      string subsequence = "";

      // Konstruuje nowy cig podsekwencji.
      for (int j = 0; j < strLen; j++)
      {
         // Sprawdza, czy j-ty bit w bitCounter jest zdefiniowany.
         // Jeli tak, pobiera j-ty znak ze str.
         if (i & (1 << j))
         {
            subsequence += str[j];
         }
      }

      // Umieszcza cig w wektorze.
      vecString.push_back(subsequence);
   }

   // Zwraca wektor.
   return vecString;
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Generator podsekwencji" << endl;

   // Wprowadza cig wejciowy.
   string str;
   cout << "Cig wejciowy -> ";
   getline(cin, str);

   // Generuje podsekwencje.
   vector<string> myvector = GenerateSubsequences(
      str);

   // Zwraca uytkownikowi wynik.
   cout << "Wszystkie podsekwencje '" << str;
   cout << "':" << endl;
   for (
      vector<string>::iterator it = myvector.begin();
      it != myvector.end();
      ++it)
   {
      cout << *it << " ";
   }
   cout << endl;

   return 0;
}
