// Projekt: BinaryString_To_Decimal.cbp
// Plik   : BinaryString_To_Decimal.cpp

#include <iostream>
#include <algorithm>
#include <cmath>

using namespace std;

int BinaryStringToDecimal(
   string binaryString)
{
   // Wstpny wynik.
   int decNumber = 0;

   // Zmienna okrelajca biec potg.
   int n;

   // Deklaruje iterator odwrotny.
   string::reverse_iterator it;

   // Iteruje po wszystkich znakach w binaryString
   // od ostatniego do pierwszego.
   for (
      it = binaryString.rbegin(), n = 0;
      it != binaryString.rend();
      ++it, ++n)
   {
      // Jeli znaleziono znak '1',
      // dodaje decNumber o biecej potdze.
      char c = *it;
      if(c == '1')
      {
         decNumber += pow(2, n);
      }
   }

   // Zwraca liczb dziesitn.
   return decNumber;
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Przeksztacanie liczby dwjkowej w dziesitn" << endl;

   // Wprowadza cig binarny.
   string binaryString;
   cout << "Wejciowy cig binarny -> ";
   getline(cin, binaryString);

   // Konwertuje na liczb dziesitn.
   int decNumber = BinaryStringToDecimal(
      binaryString);

   // Wywietla uytkownikowi wynik.
   cout << "Liczba dziesitna '" << binaryString;
   cout << "' to " << decNumber << endl;

   return 0;
}
